/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.nodechooserdlg;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.id.common.CWellKnownTID;
import de.sillysky.nyssr.impl.network.nodechooserdlg.CDialog;
import de.sillysky.nyssr.impl.network.nodechooserdlg.CSignalsNodeChooserDialog;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.IMessageSender;
import de.sillysky.nyssr.network.nodechooserdlg.IDialogNodeChooser;
import de.sillysky.nyssr.network.nodechooserdlg.records.CRecordNetworkNotifyNodeChosen;
import de.sillysky.nyssr.network.nodeinfo.CNodeInfo;
import de.sillysky.nyssr.network.router.IRouter;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.signal.properties.IPropertySignal;
import de.sillysky.nyssr.signal.properties.IPropertySignalDispatcher;
import de.sillysky.nyssr.signal.properties.IPropertySignalDispatcherFactory;
import de.sillysky.nyssr.signal.properties.IPropertySignalListener;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.util.Collection;
import java.util.UUID;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

final class CDialogNodeChooser
implements IDialogNodeChooser,
IPropertySignalListener,
IService {
    private static final ILogger LOG = CLoggerFactory.getLogger(CDialogNodeChooser.class);
    private IPropertySignalDispatcher mSignalDispatcher;
    private IMessageSender mSender;
    private IRouter mRouter;

    CDialogNodeChooser() {
    }

    public static void getDependencies(IServiceDependencyList aDependencyList) {
        aDependencyList.add(IMessageSender.class);
        aDependencyList.add(IPropertySignalDispatcherFactory.class);
        aDependencyList.add(IRouter.class);
    }

    @Override
    public void abort(CTargetAddress aOwner) {
        IPropertySignal signal = this.mSignalDispatcher.createSignal(CSignalsNodeChooserDialog.SIGNAL_CANCEL);
        signal.set("OWNER", (Object)aOwner);
        this.mSignalDispatcher.signal(signal);
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) {
        this.mSender = (IMessageSender)aServiceRegistry.getService(IMessageSender.class);
        this.mRouter = (IRouter)aServiceRegistry.getService(IRouter.class);
        IPropertySignalDispatcherFactory fac = (IPropertySignalDispatcherFactory)aServiceRegistry.getService(IPropertySignalDispatcherFactory.class);
        assert (fac != null);
        this.mSignalDispatcher = fac.createPropertySignalDispatcher(this.getClass().getSimpleName());
        this.mSignalDispatcher.addListener(CSignalsNodeChooserDialog.SIGNAL_CANCELLED, (IPropertySignalListener)this, false);
        this.mSignalDispatcher.addListener(CSignalsNodeChooserDialog.SIGNAL_NODE_CHOOSED, (IPropertySignalListener)this, false);
        aServiceRegistry.registerService(IDialogNodeChooser.class, (Object)this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.deregisterService((Object)this);
    }

    public void incomingSignal(IPropertySignal aSignal) {
        UUID id = aSignal.getSignalID();
        if (CSignalsNodeChooserDialog.SIGNAL_CANCELLED.equals(id)) {
            CTargetAddress owner = aSignal.getTargetAddress("OWNER", null);
            this.informOwner(owner, null);
        } else if (CSignalsNodeChooserDialog.SIGNAL_NODE_CHOOSED.equals(id)) {
            CNodeAddress node = aSignal.getNodeAddress("NODE_ID", null);
            CTargetAddress owner = aSignal.getTargetAddress("OWNER", null);
            LOG.info("Node chosen: {}", new Object[]{node});
            this.informOwner(owner, node);
        }
    }

    private void informOwner(CTargetAddress aOwner, CNodeAddress aNode) {
        try {
            CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)aOwner);
            env.setSender(new CTargetAddress(CWellKnownTID.ROUTER, CWellKnownNID.TRANSPORT, CNodeId.EMPTY));
            CRecord rec = CRecordNetworkNotifyNodeChosen.create();
            CRecordNetworkNotifyNodeChosen.setNode((CRecord)rec, (CNodeAddress)aNode);
            this.mSender.sendNotification(env, rec);
        }
        catch (CException e) {
            LOG.error((Throwable)e, "Exception during sending the chosen node ID.");
        }
    }

    @Override
    public void showDialog(Dialog aParent, String aTitle, boolean aModal, CTargetAddress aOwner) {
        Collection nodes = this.mRouter.getReachableNodes();
        SwingUtilities.invokeLater(() -> new CDialog((Collection<CNodeInfo>)nodes, aParent, aTitle, aModal, this.mSignalDispatcher, aOwner));
    }

    @Override
    public void showDialog(Frame aParent, String aTitle, boolean aModal, CTargetAddress aOwner) {
        Collection nodes = this.mRouter.getReachableNodes();
        SwingUtilities.invokeLater(() -> new CDialog((Collection<CNodeInfo>)nodes, aParent, aTitle, aModal, this.mSignalDispatcher, aOwner));
    }

    @Override
    public void showDialog(Window aParent, String aTitle, boolean aModal, CTargetAddress aOwner) {
        Collection nodes = this.mRouter.getReachableNodes();
        SwingUtilities.invokeLater(() -> new CDialog((Collection<CNodeInfo>)nodes, aParent, aTitle, aModal, this.mSignalDispatcher, aOwner));
    }
}

