/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.packet.factory.jsonmessage;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.network.packet.factory.jsonmessage.CPacketJsonMessage;
import de.sillysky.nyssr.impl.network.packet.factory.jsonmessage.IDependencies;
import de.sillysky.nyssr.impl.network.packet.factory.message.CPacketMessage;
import de.sillysky.nyssr.json.IJsonCompactWriter;
import de.sillysky.nyssr.json.IJsonParser;
import de.sillysky.nyssr.message.CMessage;
import de.sillysky.nyssr.network.nodeinfo.INodeInfoDatabase;
import de.sillysky.nyssr.network.packets.EPacketType;
import de.sillysky.nyssr.network.packets.IPacket;
import de.sillysky.nyssr.network.packets.IPacketBuilderRegistry;
import de.sillysky.nyssr.network.packets.IPacketFactory;
import de.sillysky.nyssr.network.packets.IPacketFactoryRegistry;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.slot.ISlotFactory;
import de.sillysky.nyssr.util.streamheader.CStreamHeaderFactoryRegistry;
import java.io.DataInput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

final class CPacketFactoryJsonMessage
implements IPacketFactory,
IService,
IDependencies {
    private CStreamHeaderFactoryRegistry<CPacketMessage> mHeaderFactoryRegistry;
    private IPacketBuilderRegistry mPacketBuilderService;
    private IJsonParser mParser;
    private IJsonCompactWriter mWriter;
    private ISlotFactory mSlotFactory;
    private INodeInfoDatabase mNodeInfoDatabase;
    private int mRunningNo = 0;

    CPacketFactoryJsonMessage() {
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws CException {
        this.mNodeInfoDatabase = (INodeInfoDatabase)aServiceRegistry.getServiceOrThrow(INodeInfoDatabase.class);
        this.mPacketBuilderService = (IPacketBuilderRegistry)aServiceRegistry.getServiceOrThrow(IPacketBuilderRegistry.class);
        this.mParser = (IJsonParser)aServiceRegistry.getServiceOrThrow(IJsonParser.class);
        this.mWriter = (IJsonCompactWriter)aServiceRegistry.getServiceOrThrow(IJsonCompactWriter.class);
        this.mSlotFactory = (ISlotFactory)aServiceRegistry.getServiceOrThrow(ISlotFactory.class);
        IPacketFactoryRegistry cpf = (IPacketFactoryRegistry)aServiceRegistry.getServiceOrThrow(IPacketFactoryRegistry.class);
        cpf.registerPacketFactory(this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        IPacketFactoryRegistry cpf = (IPacketFactoryRegistry)aServiceRegistry.getService(IPacketFactoryRegistry.class);
        if (cpf != null) {
            cpf.deregisterPacketFactory(this);
        }
    }

    @Override
    @NotNull
    public IPacket fromObject(@NotNull Object aObject) {
        ++this.mRunningNo;
        if (this.mRunningNo < 0) {
            this.mRunningNo = 0;
        }
        return new CPacketJsonMessage(this, (CMessage)aObject, this.mRunningNo);
    }

    @Override
    @NotNull
    public IPacket fromStream(@NotNull DataInput aStream, boolean aIsTest) throws IOException {
        int size = aStream.readInt();
        byte[] bytes = new byte[size];
        aStream.readFully(bytes);
        return new CPacketJsonMessage(this, bytes);
    }

    @Override
    public EPacketType getType() {
        return EPacketType.JSON_MESSAGE;
    }

    @Override
    public IJsonParser getParser() {
        return this.mParser;
    }

    @Override
    public IJsonCompactWriter getWriter() {
        return this.mWriter;
    }

    @Override
    public ISlotFactory getSlotFactory() {
        return this.mSlotFactory;
    }

    @Override
    public INodeInfoDatabase getNodeInfoDatabase() {
        return this.mNodeInfoDatabase;
    }
}

