/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.router;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.address.CSegmentId;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.network.router.CDijkstraNeighbor;
import de.sillysky.nyssr.impl.network.router.CDijkstraNode;
import de.sillysky.nyssr.impl.network.router.CDijkstraNodeList;
import de.sillysky.nyssr.impl.network.router.CUtilLinkList;
import de.sillysky.nyssr.impl.network.router.IDijkstraLinkListListener;
import de.sillysky.nyssr.impl.network.router.target.CLinkCost;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.network.router.CDijkstraLink;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.util.CUtilString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CDijkstraLinkList {
    private static final ILogger LOG = CLoggerFactory.getLogger(CDijkstraLinkList.class);
    private final List<CDijkstraLink> mLinks;
    private final CNodeAddress mLocalNodeId;
    private IDijkstraLinkListListener mListener = null;

    CDijkstraLinkList(CNodeAddress aLocalNodeId) {
        this.mLocalNodeId = aLocalNodeId;
        this.mLinks = new ArrayList<CDijkstraLink>();
    }

    CDijkstraLinkList(@NotNull CNodeAddress aLocalNodeId, @NotNull CDijkstraLinkList aLinks) {
        this.mLocalNodeId = aLocalNodeId;
        this.mLinks = new ArrayList<CDijkstraLink>(aLinks.mLinks);
    }

    public static void filterSameSegment(@NotNull List<CDijkstraLink> aList) {
        Iterator<CDijkstraLink> iterator = aList.iterator();
        while (iterator.hasNext()) {
            CDijkstraLink link = iterator.next();
            CSegmentId seg1 = link.getNode1().getSegmentId();
            CSegmentId seg2 = link.getNode2().getSegmentId();
            if (seg1.isLocal() && seg2.isLocal()) continue;
            iterator.remove();
        }
    }

    public static void filterDirectLinks(@NotNull List<CDijkstraLink> aList) {
        Iterator<CDijkstraLink> iterator = aList.iterator();
        while (iterator.hasNext()) {
            CDijkstraLink link = iterator.next();
            CNodeId nodeId1 = link.getNode1().getNodeId();
            CNodeId nodeId2 = link.getNode2().getNodeId();
            if (nodeId1.isLocal() || nodeId2.isLocal()) continue;
            iterator.remove();
        }
    }

    synchronized boolean addLink(CDijkstraLink aLink) {
        return this.addLink(aLink, true);
    }

    private synchronized boolean addLink(@NotNull CDijkstraLink aLink, boolean aDoNotify) {
        CNodeAddress nodeId2;
        boolean updated = false;
        CNodeAddress nodeId1 = aLink.getNode1();
        CDijkstraLink old = this.find(nodeId1, nodeId2 = aLink.getNode2());
        if (old == null) {
            updated = this.mLinks.add(aLink);
            LOG.trace("Link added: {}", new Object[]{aLink});
        } else if (old.update(aLink)) {
            updated = true;
            LOG.trace("Link updated: {}", new Object[]{aLink});
        }
        if (updated) {
            if (aDoNotify) {
                this.notifyListener();
            }
            if (this.mListener != null) {
                this.mListener.notifyNodeAdded(nodeId1);
                this.mListener.notifyNodeAdded(nodeId2);
            }
        }
        return updated;
    }

    void dump() {
        if (LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(CUtilString.LINE_CRLF);
            sb.append("My NodeLinks are: \n");
            for (CDijkstraLink link : this.mLinks) {
                sb.append("    ");
                sb.append(link);
                sb.append("\n");
            }
            sb.append(CUtilString.LINE_CRLF);
            LOG.debug(sb.toString());
        }
    }

    @Nullable
    CRecord createRecordWithLinks(boolean aOnlySameSegment, boolean aOnlyDirectLinks) throws CException {
        ArrayList<CDijkstraLink> links = new ArrayList<CDijkstraLink>(this.mLinks);
        if (aOnlySameSegment) {
            CDijkstraLinkList.filterSameSegment(links);
        }
        if (aOnlyDirectLinks) {
            CDijkstraLinkList.filterDirectLinks(links);
        }
        return CUtilLinkList.createRecordWithCosts(links);
    }

    @NotNull
    synchronized List<CDijkstraLink> find(CNodeAddress aNodeId) {
        ArrayList<CDijkstraLink> result = new ArrayList<CDijkstraLink>();
        for (CDijkstraLink link : this.mLinks) {
            CNodeAddress nodeId1 = link.getNode1();
            CNodeAddress nodeId2 = link.getNode2();
            if (!nodeId1.equals((Object)aNodeId) && !nodeId2.equals((Object)aNodeId)) continue;
            result.add(link);
        }
        return result;
    }

    @Nullable
    synchronized CDijkstraLink find(@NotNull UUID aConnectionId) {
        for (CDijkstraLink link : this.mLinks) {
            if (!link.getConnectionId().equals(aConnectionId)) continue;
            return link;
        }
        return null;
    }

    @Nullable
    synchronized CDijkstraLink find(@NotNull CNodeAddress aNodeId1, @NotNull CNodeAddress aNodeId2) {
        for (CDijkstraLink link : this.mLinks) {
            CNodeAddress nodeId1 = link.getNode1();
            CNodeAddress nodeId2 = link.getNode2();
            if (nodeId1.equals((Object)aNodeId1) && nodeId2.equals((Object)aNodeId2)) {
                return link;
            }
            if (!nodeId2.equals((Object)aNodeId1) || !nodeId1.equals((Object)aNodeId2)) continue;
            return link;
        }
        return null;
    }

    synchronized int getCosts(CNodeAddress aNodeId1, CNodeAddress aNodeId2) {
        CDijkstraLink link = this.find(aNodeId1, aNodeId2);
        if (link != null) {
            return link.getCosts();
        }
        return -1;
    }

    @NotNull
    synchronized Collection<CDijkstraNeighbor> getNeighbors(CNodeAddress aNodeId) {
        ArrayList<CDijkstraNeighbor> result = new ArrayList<CDijkstraNeighbor>();
        for (CDijkstraLink link : this.mLinks) {
            CNodeAddress nodeId1 = link.getNode1();
            CNodeAddress nodeId2 = link.getNode2();
            if (nodeId1.equals((Object)aNodeId)) {
                result.add(new CDijkstraNeighbor(nodeId2, link.getCosts()));
                continue;
            }
            if (!nodeId2.equals((Object)aNodeId)) continue;
            result.add(new CDijkstraNeighbor(nodeId1, link.getCosts()));
        }
        return result;
    }

    @NotNull
    public CDijkstraNodeList getNodes() {
        CDijkstraNodeList result = new CDijkstraNodeList(this.mLocalNodeId);
        for (CDijkstraLink link : this.mLinks) {
            result.add(link.getNode1());
            result.add(link.getNode2());
        }
        return result;
    }

    boolean isEmpty() {
        return this.mLinks.isEmpty();
    }

    private void notifyListener() {
        this.dump();
        if (this.mListener != null) {
            this.mListener.notifyLinkListUpdated();
        }
    }

    synchronized boolean removeLink(@NotNull CNodeAddress aNodeId1, @NotNull CNodeAddress aNodeId2) {
        boolean result = false;
        CDijkstraLink link = this.find(aNodeId1, aNodeId2);
        if (link != null) {
            this.mLinks.remove(link);
            LOG.debug("Router: Remove Link {}", new Object[]{link});
            this.notifyListener();
            result = true;
        }
        return result;
    }

    synchronized boolean removeNodeId(CNodeAddress aNodeId) {
        boolean result = false;
        Iterator<CDijkstraLink> it = this.mLinks.iterator();
        while (it.hasNext()) {
            CDijkstraLink link = it.next();
            CNodeAddress nodeId = link.getNode1();
            if (nodeId.equals((Object)aNodeId)) {
                it.remove();
                result = true;
                continue;
            }
            nodeId = link.getNode2();
            if (!nodeId.equals((Object)aNodeId)) continue;
            it.remove();
            result = true;
        }
        if (result) {
            this.notifyListener();
        }
        return result;
    }

    void removeUnreachableLinks(CDijkstraNodeList mNodes) {
        boolean updated = false;
        Iterator<CDijkstraLink> it = this.mLinks.iterator();
        while (it.hasNext()) {
            boolean remove = false;
            CDijkstraLink link = it.next();
            CNodeAddress nodeId1 = link.getNode1();
            CDijkstraNode node1 = mNodes.get(nodeId1);
            if (node1 == null) {
                remove = true;
            } else if (!node1.isSettled()) {
                remove = true;
            } else {
                CNodeAddress nodeId2 = link.getNode1();
                CDijkstraNode node2 = mNodes.get(nodeId2);
                if (node2 == null) {
                    remove = true;
                } else if (!node2.isSettled()) {
                    remove = true;
                }
            }
            if (!remove) continue;
            LOG.debug("Remove link {}", new Object[]{link});
            it.remove();
            updated = true;
        }
        if (updated) {
            this.dump();
        }
    }

    void setListener(IDijkstraLinkListListener aListener) {
        this.mListener = aListener;
    }

    boolean updateCosts(@NotNull CLinkCost aCostEntry) {
        boolean updated = false;
        CDijkstraLink link = this.find(aCostEntry.getConnectionId());
        if (link != null && (updated = link.updateCosts(aCostEntry.getCost(), aCostEntry.getTime()))) {
            this.notifyListener();
        }
        return updated;
    }

    boolean updateLinks(@NotNull Collection<CDijkstraLink> aLinks) {
        boolean result = false;
        for (CDijkstraLink link : aLinks) {
            boolean updated = this.addLink(link, false);
            if (!updated) continue;
            result = true;
        }
        if (result) {
            this.notifyListener();
        }
        return result;
    }

    public List<CDijkstraLink> getLinkList() {
        return new ArrayList<CDijkstraLink>(this.mLinks);
    }
}

