/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.context.target;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.EIdType;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.impl.remoteskin.client.context.target.CRemoteSkinClientContextTarget;
import de.sillysky.nyssr.impl.remoteskin.client.context.target.IPrivateDependencies;
import de.sillysky.nyssr.impl.service.CServiceRegistry;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.namespace.INamespaceFactory;
import de.sillysky.nyssr.remoteskin.client.IRemoteSkinClientContextTargetFactory;
import de.sillysky.nyssr.remoteskin.model.IRemoteSkinClientContext;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.signal.properties.IPropertySignalDispatcher;
import de.sillysky.nyssr.target.registry.ITargetRegistry;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CRemoteSkinClientContextTargetFactory
implements IService,
IRemoteSkinClientContextTargetFactory,
IPrivateDependencies {
    private final Map<IId, CRemoteSkinClientContextTarget> mTargets = new ConcurrentHashMap<IId, CRemoteSkinClientContextTarget>();
    private INamespaceFactory mNamespaceFactory;
    private IPropertySignalDispatcher mSystemSignalDispatcher;

    CRemoteSkinClientContextTargetFactory() {
    }

    static void addDependencies(IServiceDependencyList aDependencyList) {
        aDependencyList.add(INamespaceFactory.class);
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws CException {
        this.mNamespaceFactory = (INamespaceFactory)aServiceRegistry.getServiceOrThrow(INamespaceFactory.class);
        this.mSystemSignalDispatcher = (IPropertySignalDispatcher)aServiceRegistry.getServiceOrThrow(IPropertySignalDispatcher.class);
        aServiceRegistry.registerService(IRemoteSkinClientContextTargetFactory.class, (Object)this);
    }

    @Override
    @Nullable
    public CTargetAddress createTarget(@NotNull IRemoteSkinClientContext aContext) throws Exception {
        IId nid = CIdFactory.randomOfType((EIdType)EIdType.INT);
        INamespace namespace = this.mNamespaceFactory.createAndRegisterNamespace(nid, "RemoteSkin");
        ITargetRegistry targetRegistry = namespace.getTargetRegistry();
        aContext.setTargetRegistry(targetRegistry);
        CRemoteSkinClientContextTarget tgt = new CRemoteSkinClientContextTarget();
        tgt.activate(this, aContext, targetRegistry);
        this.mTargets.put(aContext.getId(), tgt);
        return tgt.getAddress();
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.deregisterService((Object)this);
    }

    @Override
    public void deleteTarget(@NotNull IId aContextId) throws CException {
        CRemoteSkinClientContextTarget tgt = this.mTargets.remove(aContextId);
        if (tgt != null) {
            IId nid = tgt.getAddress().getNID();
            CServiceRegistry sr = CServiceRegistry.getInstance();
            tgt.deactivate((IServiceRegistry)sr);
            this.mNamespaceFactory.deleteNamespace(nid);
        }
    }

    @Override
    public IPropertySignalDispatcher getSystemSignalDispatcher() {
        return this.mSystemSignalDispatcher;
    }
}

