/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.converter.impl.converter;

import java.util.ArrayList;
import java.util.Collection;

public final class CUtilConverter {
    public static boolean checkNull(String aStr) {
        if (aStr == null) {
            return true;
        }
        if (aStr.isEmpty()) {
            return true;
        }
        return "null".equals(aStr.toLowerCase());
    }

    public static String escape(String aStr) {
        String s2;
        if (CUtilConverter.checkNull(aStr)) {
            return null;
        }
        boolean escaped = false;
        StringBuilder sb = new StringBuilder(aStr.length() + 30);
        String s1 = aStr.trim();
        if (s1.equals(s2 = CUtilConverter.trim(s1, '\"'))) {
            s2 = CUtilConverter.trim(s1, '\'');
        }
        for (char c : s2.toCharArray()) {
            if (c == ',') {
                sb.append('\\');
                escaped = true;
            }
            sb.append(c);
        }
        return escaped ? sb.toString() : aStr;
    }

    private static int findQuote(char[] aCharArray, int aStart, char aChar) {
        boolean escape = false;
        for (int i = aStart; i < aCharArray.length; ++i) {
            char c = aCharArray[i];
            if (c == '\\') {
                escape = !escape;
                continue;
            }
            if (c == aChar) {
                if (escape) continue;
                return i;
            }
            escape = false;
        }
        return -1;
    }

    public static String iterableToString(Iterable<?> aValue) {
        StringBuilder sb = new StringBuilder(2000);
        sb.append("[");
        boolean once = false;
        for (Object o : aValue) {
            if (!once) {
                once = true;
            } else {
                sb.append(',');
            }
            sb.append(CUtilConverter.toString(o));
        }
        sb.append("]");
        return sb.toString();
    }

    public static Collection<String> split(String aStr) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder sb = new StringBuilder(200);
        boolean escaped = false;
        char lastChar = '\u0000';
        char[] cArray = aStr.toCharArray();
        int n = cArray.length;
        block4: for (int i = 0; i < n; ++i) {
            char c;
            lastChar = c = cArray[i];
            switch (c) {
                case '\\': {
                    escaped = !escaped;
                    continue block4;
                }
                case ',': {
                    if (!escaped) {
                        list.add(CUtilConverter.strip(sb.toString()));
                        sb.setLength(0);
                        continue block4;
                    }
                    escaped = false;
                    break;
                }
                default: {
                    if (!escaped) break;
                    sb.append('\\');
                    escaped = false;
                }
            }
            sb.append(c);
        }
        if (sb.length() > 0 || lastChar == ',') {
            list.add(CUtilConverter.strip(sb.toString()));
        }
        return list;
    }

    public static Collection<String> split2(String aStr) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder sb = new StringBuilder(200);
        StringBuilder whitespaces = new StringBuilder(20);
        boolean escape = false;
        boolean in = false;
        char lastChar = '\u0000';
        char[] charArray = aStr.toCharArray();
        block6: for (int i = 0; i < charArray.length; ++i) {
            char c;
            lastChar = c = charArray[i];
            if (!in && Character.isWhitespace(c)) continue;
            switch (c) {
                case '\\': {
                    escape = true;
                    break;
                }
                case ',': {
                    if (escape) {
                        sb.append(c);
                        escape = false;
                        break;
                    }
                    list.add(sb.toString());
                    sb.setLength(0);
                    escape = false;
                    in = false;
                    whitespaces.setLength(0);
                    continue block6;
                }
                case '\'': {
                    if (escape) {
                        sb.append(c);
                        escape = false;
                        break;
                    }
                    int pos = CUtilConverter.findQuote(charArray, i + 1, '\'');
                    if (pos < 0) break;
                    ++i;
                    while (i < pos) {
                        sb.append(charArray[i]);
                        ++i;
                    }
                    break;
                }
                case '\"': {
                    if (escape) {
                        sb.append(c);
                        escape = false;
                        break;
                    }
                    int pos = CUtilConverter.findQuote(charArray, i + 1, '\"');
                    if (pos < 0) break;
                    ++i;
                    while (i < pos) {
                        sb.append(charArray[i]);
                        ++i;
                    }
                    break;
                }
                default: {
                    if (escape) {
                        sb.append('\\');
                        sb.append(c);
                        escape = false;
                        break;
                    }
                    if (Character.isWhitespace(c)) {
                        whitespaces.append(c);
                        break;
                    }
                    if (whitespaces.length() > 0) {
                        sb.append((CharSequence)whitespaces);
                        whitespaces.setLength(0);
                    }
                    sb.append(c);
                }
            }
            in = true;
        }
        if (sb.length() > 0 || lastChar == ',') {
            list.add(sb.toString());
        }
        return list;
    }

    private static String strip(String aStr) {
        String s1 = aStr.trim();
        if (CUtilConverter.checkNull(s1)) {
            return null;
        }
        String s2 = CUtilConverter.trim(s1, '\"');
        if (s1.equals(s2)) {
            s2 = CUtilConverter.trim(s1, '\'');
        }
        return s2;
    }

    public static String toString(Object aObject) {
        String result = "";
        if (aObject != null && !(result = aObject.toString()).isEmpty()) {
            result = CUtilConverter.escape(result);
        }
        return result;
    }

    public static String trim(String aStr, char aChar) {
        if (aStr == null) {
            return null;
        }
        int l = aStr.length();
        if (l >= 2 && aStr.charAt(0) == aChar && aStr.charAt(l - 1) == aChar) {
            return aStr.substring(1, l - 1);
        }
        return aStr;
    }

    private CUtilConverter() {
    }
}

