/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.kernel;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.id.common.CWellKnownTID;
import de.sillysky.nyssr.impl.properties.string.CPackageImplPropertiesString;
import de.sillysky.nyssr.impl.service.CServiceRegistry;
import de.sillysky.nyssr.impl.shutdown.records.CRecordShutdown;
import de.sillysky.nyssr.kernel.IShutDown;
import de.sillysky.nyssr.kernel.configuration.IKernelConfiguration;
import de.sillysky.nyssr.kernel.records.CPackageKernelRecords;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.IMessageSender;
import de.sillysky.nyssr.module.CModuleCommandLineInterface;
import de.sillysky.nyssr.module.CModuleCopyright;
import de.sillysky.nyssr.module.CModuleHsm;
import de.sillysky.nyssr.module.CModuleId;
import de.sillysky.nyssr.module.CModuleJob;
import de.sillysky.nyssr.module.CModuleJson;
import de.sillysky.nyssr.module.CModuleKernelConfiguration;
import de.sillysky.nyssr.module.CModuleKernelTargets;
import de.sillysky.nyssr.module.CModuleLogCatcher;
import de.sillysky.nyssr.module.CModuleMessage;
import de.sillysky.nyssr.module.CModuleMessageHandler;
import de.sillysky.nyssr.module.CModuleMessageHook;
import de.sillysky.nyssr.module.CModuleMessageLogger;
import de.sillysky.nyssr.module.CModuleMessageQueue;
import de.sillysky.nyssr.module.CModuleMessageSender;
import de.sillysky.nyssr.module.CModuleNameDb;
import de.sillysky.nyssr.module.CModuleNamespace;
import de.sillysky.nyssr.module.CModuleNanoService;
import de.sillysky.nyssr.module.CModulePlugIn;
import de.sillysky.nyssr.module.CModulePreferences;
import de.sillysky.nyssr.module.CModuleSession;
import de.sillysky.nyssr.module.CModuleSignal;
import de.sillysky.nyssr.module.CModuleTarget;
import de.sillysky.nyssr.module.CModuleTargetListener;
import de.sillysky.nyssr.module.CModuleTest;
import de.sillysky.nyssr.module.CModuleThread;
import de.sillysky.nyssr.module.CModuleTimer;
import de.sillysky.nyssr.plugin.IPlugInManager;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.target.registry.ITargetRegistry;
import de.sillysky.nyssr.util.properties.CStringProperties;
import de.sillysky.nyssr.util.time.CUtilLocalDateTime;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.BackingStoreException;
import org.jetbrains.annotations.NotNull;

public final class CKernel
implements IShutDown {
    private static final ILogger LOG = CLoggerFactory.getLogger(CKernel.class);
    private static final ILogger LOG_STARTUP = CLoggerFactory.getLogger("startup");
    private final AtomicBoolean mIsShutdown = new AtomicBoolean(false);

    public CKernel(@NotNull CStringProperties aProperties) throws CException {
        CStringProperties properties = new CStringProperties();
        for (String key : aProperties.getKeys()) {
            String value = aProperties.get(key);
            properties.put(key, value);
        }
        CServiceRegistry serviceRegistry = CServiceRegistry.getInstance();
        serviceRegistry.addStarter(new CPackageImplPropertiesString());
        CModuleKernelConfiguration.initialize(serviceRegistry, properties);
        this.initialize(serviceRegistry);
    }

    public static void main(@NotNull String[] aArgs) throws CException, BackingStoreException {
        CStringProperties properties = new CStringProperties();
        for (String a : aArgs) {
            String value;
            String key;
            if (a.indexOf(61) <= 0) continue;
            System.out.println("Argument: " + a);
            String[] strings = a.split("=");
            if (strings.length == 1) {
                key = strings[0].trim();
                value = "";
                properties.put(key, "");
            }
            if (strings.length != 2) continue;
            key = strings[0].trim();
            value = strings[1].trim();
            properties.put(key, value);
        }
        new CKernel(properties);
    }

    private void initialize(CServiceRegistry aServiceRegistry) throws CException {
        aServiceRegistry.registerStartServiceListener(ITargetRegistry.class, (aServiceRegistry1, aServiceType, aClass, aInstance, aProperties) -> {
            String nid;
            if (aProperties != null && "TRANSPORT".equals(nid = aProperties.get("nid", ""))) {
                long millis = 0L;
                IKernelConfiguration kc = aServiceRegistry1.getService(IKernelConfiguration.class);
                if (kc != null) {
                    millis = CUtilLocalDateTime.diffInMillis(kc.getStartTime());
                }
                LOG_STARTUP.info("------------- Kernel started in {} milliseconds.", millis);
            }
        });
        aServiceRegistry.registerStartServiceListener(IPlugInManager.class, (aServiceRegistry12, aEventType, aClass, aInstance, aProperties) -> {
            long millis = 0L;
            IKernelConfiguration kc = aServiceRegistry12.getService(IKernelConfiguration.class);
            if (kc != null) {
                millis = CUtilLocalDateTime.diffInMillis(kc.getStartTime());
            }
            LOG_STARTUP.info("------------- Plugins started in {} milliseconds.", millis);
            aServiceRegistry12.allowStatusPrint();
            aServiceRegistry12.printStatus();
        });
        CModuleLogCatcher.initialize(aServiceRegistry);
        try {
            CModulePreferences.initialize(aServiceRegistry);
            CModuleThread.initialize(aServiceRegistry);
            CModuleId.initialize(aServiceRegistry);
            CModuleTest.initialize(aServiceRegistry);
            CModuleSignal.inititialize(aServiceRegistry);
            CModuleMessage.initialize(aServiceRegistry);
            CModuleNameDb.initialize(aServiceRegistry);
            CModuleMessageLogger.initialize(aServiceRegistry);
            CModuleHsm.initialize(aServiceRegistry);
            CModuleNamespace.initialize(aServiceRegistry);
            CModuleMessageHandler.initialize(aServiceRegistry);
            CModuleMessageHook.initialize(aServiceRegistry);
            CModuleMessageSender.initialize(aServiceRegistry);
            CModuleTargetListener.initialize(aServiceRegistry);
            CModuleNanoService.initialize(aServiceRegistry);
            CModuleTarget.initialize(aServiceRegistry);
            CModuleSession.initialize(aServiceRegistry);
            CModuleMessageQueue.initialize(aServiceRegistry);
            CModuleTimer.initialize(aServiceRegistry);
            CModuleCopyright.initialize(aServiceRegistry);
            CModuleJson.initialize(aServiceRegistry);
            CModuleCommandLineInterface.initialize(aServiceRegistry);
            aServiceRegistry.addStarter(new CPackageKernelRecords());
            aServiceRegistry.registerService(IShutDown.class, this);
            aServiceRegistry.registerService(CKernel.class, this);
            CModuleJob.initialize(aServiceRegistry);
            CModuleKernelTargets.initialize(aServiceRegistry);
            CModulePlugIn.initialize(aServiceRegistry);
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "Exception in Kernel: ");
            throw new CException(2).append(e);
        }
    }

    @Override
    public boolean isShutDownInProgress() {
        return this.mIsShutdown.get();
    }

    @Override
    public void shutDownHard(int aCode) {
        System.exit(aCode);
    }

    @Override
    public void shutDown(int aCode) {
        this.mIsShutdown.set(true);
        IMessageSender messageSender = CServiceRegistry.getInstance().getService(IMessageSender.class);
        if (messageSender == null) {
            this.shutDownHard(aCode);
        } else {
            try {
                CTargetAddress address = new CTargetAddress(CWellKnownTID.KERNEL, CWellKnownNID.SYSTEM, messageSender.getNodeAddress());
                CEnvelope env = CEnvelope.forLocalNanoService(CWellKnownNID.SYSTEM);
                env.setSender(address);
                CRecord rec = CRecordShutdown.create();
                CRecordShutdown.setCode(rec, aCode);
                messageSender.sendNotification(env, rec);
            }
            catch (CException e) {
                LOG.error((Throwable)e, "Can't send shutdown message.");
            }
        }
    }
}

