/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.plugin.target;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.common.CWellKnownTID;
import de.sillysky.nyssr.impl.plugin.target.IDependencies;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.plugin.IPlugInEntry;
import de.sillysky.nyssr.plugin.records.CRecordGetPlugInList;
import de.sillysky.nyssr.plugin.records.CRecordPlugIn;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.helper.CRecordHelper;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.registry.ITargetRegistry;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

final class CTargetForPluginManager
extends CTarget
implements IService {
    private final IDependencies mDependencies;

    CTargetForPluginManager(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordGetPlugInList.ID, this::asyncGetPlugInList);
    }

    @Override
    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        ITargetRegistry tr = this.mDependencies.getSystemNamespace().getTargetRegistry();
        tr.registerTarget(this, CWellKnownTID.PLUGIN_MANAGER);
    }

    @Override
    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        this.deregisterTarget();
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CRecordHelper.addObserver(CRecordGetPlugInList.class, this, false);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncGetPlugInList(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        Collection<IPlugInEntry> plugIns = this.mDependencies.getPlugInManager().getPlugIns();
        if (plugIns == null || plugIns.isEmpty()) {
            aEnvelope.setResult(4, "PlugInList is empty.");
        } else {
            boolean loadedOnly = CRecordGetPlugInList.getLoadedOnly(aRecord, false);
            ArrayList<CRecord> records = new ArrayList<CRecord>();
            for (IPlugInEntry e : plugIns) {
                if (loadedOnly && !e.hasSuccess()) continue;
                CRecord rec = this.toRecord(e);
                records.add(rec);
            }
            if (!records.isEmpty()) {
                CRecord[] arr = new CRecord[records.size()];
                arr = records.toArray(arr);
                CRecordGetPlugInList.setPlugins(aRecord, arr);
            }
            aEnvelope.setResultSuccess();
        }
        return true;
    }

    @NotNull
    private CRecord toRecord(@NotNull IPlugInEntry aEntry) throws CException {
        CRecord rec = CRecordPlugIn.create();
        CRecordPlugIn.setClass(rec, aEntry.getPlugInClassName());
        CRecordPlugIn.setErrorCode(rec, aEntry.getResult().getCode());
        CRecordPlugIn.setErrorMessage(rec, aEntry.getResult().getText());
        CRecordPlugIn.setLoaded(rec, aEntry.hasSuccess());
        CRecordPlugIn.setName(rec, aEntry.getName());
        CRecordPlugIn.setPath(rec, aEntry.getPath());
        CRecordPlugIn.setStartTime(rec, aEntry.getStartTime());
        return rec;
    }
}

