/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.slot;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonStringProperty;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISingleSlotTypeFactory;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.util.properties.CStringProperties;
import de.sillysky.nyssr.util.properties.CStringProperty;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CSlotStringProperties
implements ISlot,
ISingleSlotTypeFactory {
    private static final ILogger LOG = CLoggerFactory.getLogger(CSlotStringProperties.class);
    private final CStringProperties mValue;

    public CSlotStringProperties() {
        this.mValue = null;
    }

    private CSlotStringProperties(CStringProperties aValue) {
        this.mValue = aValue;
    }

    private static CSlotStringProperties create(Object aValue) {
        CSlotStringProperties result = null;
        if (aValue == null) {
            result = new CSlotStringProperties();
        } else if (aValue instanceof CStringProperties) {
            result = new CSlotStringProperties((CStringProperties)aValue);
        } else if (aValue instanceof String) {
            try {
                CStringProperties sps = CStringProperties.fromStringArrayString((String)aValue);
                result = new CSlotStringProperties(sps);
            }
            catch (Exception e) {
                LOG.error("Error creating StringProperties from {}", aValue);
            }
        } else if (aValue instanceof List) {
            try {
                CStringProperties sp = CStringProperties.fromList((List)aValue);
                result = new CSlotStringProperties(sp);
            }
            catch (CException e) {
                LOG.error("Error creating StringProperties from {}", aValue);
            }
        }
        return result;
    }

    @Contract(value="_ -> new")
    @NotNull
    private static CSlotStringProperties fromStream(@NotNull DataInput aStream) throws IOException {
        boolean exist = aStream.readBoolean();
        if (!exist) {
            return new CSlotStringProperties();
        }
        CStringProperties value = CStringProperties.fromStream(aStream);
        return new CSlotStringProperties(value);
    }

    @Override
    public boolean equals(Object aO) {
        if (this == aO) {
            return true;
        }
        if (aO == null || this.getClass() != aO.getClass()) {
            return false;
        }
        CSlotStringProperties that = (CSlotStringProperties)aO;
        return Objects.equals(this.mValue, that.mValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.mValue);
    }

    @Override
    @Nullable
    public ISlot fromObject(@NotNull CSlotType aType, @Nullable Object aValue) {
        if (this.getType().equals(aType)) {
            return CSlotStringProperties.create(aValue);
        }
        return null;
    }

    @Override
    @Nullable
    public ISlot fromJson(@Nullable Object aValue, @NotNull Map<Integer, byte[]> aByteArrayStore) {
        CJsonArray arr;
        if (aValue instanceof CJsonArray && (arr = (CJsonArray)aValue).size() > 0) {
            CStringProperties sp = new CStringProperties();
            boolean i = false;
            for (Object child : arr.getChildren()) {
                CStringProperty p = CUtilJsonStringProperty.fromJson(child);
                if (p == null) continue;
                sp.put(p);
            }
            return new CSlotStringProperties(sp);
        }
        return null;
    }

    @Override
    @NotNull
    public Class<?> getClassOfProducedObject() {
        return CStringProperties.class;
    }

    @Override
    @NotNull
    public ISlot copy() {
        CStringProperties sps = new CStringProperties(this.mValue);
        return new CSlotStringProperties(sps);
    }

    @Override
    @NotNull
    public CSlotType getType() {
        return CCommonSlotType.STRING_PROPERTIES;
    }

    @Override
    public Object getValue() {
        return this.mValue;
    }

    @Override
    public boolean isContentEqualTo(Object aValue) {
        if (aValue == null) {
            return this.mValue == null;
        }
        if (this.mValue != null) {
            return this.mValue.equals(aValue);
        }
        return false;
    }

    @Override
    @Nullable
    public ISlot readSlot(@NotNull DataInput aStream, @NotNull CSlotType aType) throws IOException {
        if (this.getType().equals(aType)) {
            return CSlotStringProperties.fromStream(aStream);
        }
        return null;
    }

    @Override
    public void toStream(@NotNull DataOutput aStream) throws IOException {
        if (this.mValue == null) {
            aStream.writeBoolean(false);
        } else {
            aStream.writeBoolean(true);
            this.mValue.toStream(aStream);
        }
    }

    public String toString() {
        return this.mValue == null ? "null" : this.mValue.toString();
    }

    @Override
    @NotNull
    public String valueToString() {
        if (this.mValue != null) {
            return this.mValue.valueToString();
        }
        return null;
    }

    @Override
    @Nullable
    public Object toJson(@NotNull Map<Integer, byte[]> aBinaries) {
        if (this.mValue != null && this.mValue.size() > 0) {
            CJsonArray arr = new CJsonArray();
            for (String key : this.mValue.getKeys()) {
                String value = this.mValue.get(key);
                CStringProperty p = new CStringProperty(key, value);
                arr.add(CUtilJsonStringProperty.toJson(p));
            }
            return arr;
        }
        return null;
    }
}

