/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.crypt;

import de.sillysky.nyssr.util.string.CUtilBase64;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.jetbrains.annotations.NotNull;

public class CUtilAes {
    private static final String ALGORITHM = "AES/CBC/PKCS5Padding";
    private static final int AES_KEY_SIZE = 256;

    private CUtilAes() {
    }

    public static SecretKey generateKey() throws Exception {
        KeyGenerator keyGen = KeyGenerator.getInstance("AES");
        keyGen.init(256);
        return keyGen.generateKey();
    }

    public static byte @NotNull [] pack(@NotNull SecretKey aKey, byte[] aUnEncoded) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        byte[] iv = new byte[16];
        SecureRandom random = new SecureRandom();
        random.nextBytes(iv);
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(1, (Key)aKey, ivSpec);
        byte[] bytes = cipher.doFinal(aUnEncoded);
        byte[] bytes2 = new byte[iv.length + bytes.length];
        System.arraycopy(iv, 0, bytes2, 0, iv.length);
        System.arraycopy(bytes, 0, bytes2, iv.length, bytes.length);
        return bytes2;
    }

    public static byte[] unpack(@NotNull SecretKey aKey, byte[] aEncoded) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        byte[] iv = new byte[16];
        System.arraycopy(aEncoded, 0, iv, 0, iv.length);
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        byte[] encodedWithoutIv = new byte[aEncoded.length - iv.length];
        System.arraycopy(aEncoded, iv.length, encodedWithoutIv, 0, encodedWithoutIv.length);
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(2, (Key)aKey, ivSpec);
        return cipher.doFinal(encodedWithoutIv);
    }

    public static void main(@NotNull String[] aArgs) throws Exception {
        SecretKey secretKey = CUtilAes.generateKey();
        byte[] key = secretKey.getEncoded();
        System.out.println(CUtilBase64.encodeToString(key));
    }
}

