/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.files;

import java.io.File;
import java.io.FileFilter;

public class CExtensionFileFilter
implements FileFilter {
    private final String[] mExtensions;
    private final boolean mAcceptDirectories;

    public CExtensionFileFilter(String aExtension, boolean aAcceptDirectories) {
        this(new String[]{aExtension}, aAcceptDirectories);
    }

    public CExtensionFileFilter(String[] aExtensions, boolean aAcceptDirectories) {
        this.mAcceptDirectories = aAcceptDirectories;
        this.mExtensions = new String[aExtensions.length];
        for (int i = 0; i < aExtensions.length; ++i) {
            this.mExtensions[i] = aExtensions[i].toLowerCase();
        }
    }

    @Override
    public boolean accept(File aFile) {
        if (aFile.isDirectory()) {
            return this.mAcceptDirectories;
        }
        String filePath = aFile.getAbsolutePath().toLowerCase();
        for (String ext : this.mExtensions) {
            if (!filePath.endsWith(ext)) continue;
            return true;
        }
        return false;
    }
}

