/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.web.dialog.edituser;

import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.impl.web.dialog.edituser.C00301EditUser;
import de.sillysky.nyssr.impl.web.dialog.edituser.CConstants;
import de.sillysky.nyssr.impl.web.dialog.edituser.IDependencies;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.nanoservice.CDescriptionOfRecord;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.web.dialog.records.CRecordShowWebDialog;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

class C00301EditUserFactory
extends CTarget
implements IService {
    private final IDependencies mDependencies;

    public C00301EditUserFactory(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordShowWebDialog.ID, this::asyncShowWebDialog);
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        IId nid = CIdFactory.fromObject((Object)"WebDialogEditUser_00301");
        INamespace ns = this.mDependencies.getNamespaceFactory().createAndRegisterNamespace(nid, "WebDialogEditUser_00301");
        ns.getTargetRegistry().registerTarget((ITarget)this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        this.mDependencies.getHelperForLocalMicroServices().deregisterMicroServices(this.getAddress());
        this.deregisterTarget();
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.registerMicroService();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncShowWebDialog(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        String sessionToken = CRecordShowWebDialog.getSessionToken((CRecord)aRecord, null);
        CUtilCheck.checkNotNull((Object)sessionToken, (String)"sessionToken missing", (Object[])new Object[0]);
        CTargetAddress clientTargetAddress = CRecordShowWebDialog.getClientTargetAddress((CRecord)aRecord, null);
        CUtilCheck.checkNotNull((Object)clientTargetAddress, (String)"clientTargetAddress missing", (Object[])new Object[0]);
        CTargetAddress ownerTargetAddress = CRecordShowWebDialog.getOwnerTargetAddress((CRecord)aRecord, null);
        CUtilCheck.checkNotNull((Object)ownerTargetAddress, (String)"ownerTargetAddress missing", (Object[])new Object[0]);
        String[] params = CRecordShowWebDialog.getParams((CRecord)aRecord, null);
        CUtilCheck.checkNotNull((Object)params, (String)"userId missing", (Object[])new Object[0]);
        CUtilCheck.checkTrue((params.length > 0 ? 1 : 0) != 0, (String)"userId missing", (Object[])new Object[0]);
        String userId = params[0];
        CUtilCheck.checkEmptyString((Object)userId, (String)"userId missing", (Object[])new Object[0]);
        C00301EditUser tgt = new C00301EditUser(sessionToken, clientTargetAddress, ownerTargetAddress, userId);
        this.getTargetRegistry().registerTarget((ITarget)tgt);
        CRecordShowWebDialog.setDialogTargetAddress((CRecord)aRecord, (CTargetAddress)tgt.getAddress());
        aEnvelope.setResultSuccess();
        return true;
    }

    private void registerMicroService() throws CException {
        ArrayList<CDescriptionOfRecord> nanos = new ArrayList<CDescriptionOfRecord>();
        nanos.add(new CDescriptionOfRecord(CRecordShowWebDialog.ID, "Create and show the add user dialog"));
        this.mDependencies.getHelperForLocalMicroServices().registerMicroService(CConstants.MICRO_SERVICE_ID, "WebDialogEditUser_00301", nanos, CNodeId.getLocal().getId(), this.getAddress());
    }
}

