/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.dialog.preset;

import de.sillysky.nyssr.impl.dialog.preset.CPreset;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CPresetList {
    private final HashMap<String, CPreset> mPresets = new HashMap();
    private final TreeSet<String> mPresetNames = new TreeSet();
    private String mSelected;

    CPresetList() {
    }

    void add(@NotNull CPreset aPreset) {
        String name = aPreset.getName();
        this.mPresets.put(name, aPreset);
        this.mPresetNames.add(name);
    }

    void clear() {
        this.mPresets.clear();
        this.mPresetNames.clear();
    }

    @Nullable
    CPreset get(@Nullable String aName) {
        return aName == null ? null : this.mPresets.get(aName);
    }

    @Nullable
    String getNameOfSelectedPreset() {
        return this.mSelected;
    }

    @NotNull
    Collection<String> getPresetNames() {
        return this.mPresetNames;
    }

    @Nullable
    CPreset getSelectedPreset() {
        return this.mPresets.get(this.mSelected);
    }

    String selectFirst() {
        Iterator<String> iterator = this.mPresetNames.iterator();
        if (iterator.hasNext()) {
            this.mSelected = iterator.next();
        }
        return this.mSelected;
    }

    void setSelected(@NotNull String aSelected) {
        this.mSelected = aSelected;
    }

    public boolean isEmpty() {
        return this.mPresetNames.isEmpty();
    }
}

