/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.app.factory.collector;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.app.factory.collector.CConstantsAppFactoryCollector;
import de.sillysky.nyssr.app.factory.collector.records.CRecordAddAppFactory;
import de.sillysky.nyssr.app.factory.collector.records.CRecordApplication;
import de.sillysky.nyssr.app.factory.collector.records.CRecordLaunchApplication;
import de.sillysky.nyssr.app.factory.collector.records.CRecordRemoveAppFactory;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.impl.app.factory.collector.CApplicationEntry;
import de.sillysky.nyssr.impl.app.factory.collector.CApplicationFactoryEntry;
import de.sillysky.nyssr.impl.app.factory.collector.IDependencies;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.nanoservice.CDescriptionOfRecord;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.util.properties.CStringProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CAppCollectorUtils {
    private CAppCollectorUtils() {
    }

    @NotNull
    static CApplicationEntry unpackApplication(@NotNull CRecord aAppRecord) throws CException {
        UUID id = CRecordApplication.getId((CRecord)aAppRecord, null);
        CUtilCheck.checkNotNullEx((Object)id, (String)"Missing app id", (Object[])new Object[0]);
        String name = CRecordApplication.getName((CRecord)aAppRecord, (String)"");
        String shortDescription = CRecordApplication.getShortDescription((CRecord)aAppRecord, (String)"");
        String longDescription = CRecordApplication.getLongDescription((CRecord)aAppRecord, (String)"");
        String icon = CRecordApplication.getIcon((CRecord)aAppRecord, (String)"");
        String platform = CRecordApplication.getPlatform((CRecord)aAppRecord, (String)"");
        String[] permissions = CRecordApplication.getPermissions((CRecord)aAppRecord, (String[])new String[0]);
        CStringProperties properties = CRecordApplication.getProperties((CRecord)aAppRecord, (CStringProperties)new CStringProperties());
        return new CApplicationEntry(id, name, shortDescription, longDescription, icon, platform, permissions, properties);
    }

    @NotNull
    static CRecord packApplication(@NotNull CApplicationEntry aEntry) throws CException {
        CRecord record = CRecordApplication.create();
        CRecordApplication.setId((CRecord)record, (UUID)aEntry.getApplicationId());
        CRecordApplication.setName((CRecord)record, (String)aEntry.getApplicationName());
        CRecordApplication.setShortDescription((CRecord)record, (String)aEntry.getShortApplicationDescription());
        CRecordApplication.setLongDescription((CRecord)record, (String)aEntry.getLongApplicationDescription());
        CRecordApplication.setIcon((CRecord)record, (String)aEntry.getIconPath());
        CRecordApplication.setPermissions((CRecord)record, (String[])aEntry.getPermissions());
        CRecordApplication.setProperties((CRecord)record, (CStringProperties)aEntry.getProperties());
        return record;
    }

    static void registerMicroservice(@NotNull IDependencies aDependencies, @NotNull IId aInstanceId, @NotNull CTargetAddress aAddress) throws CException {
        ArrayList<CDescriptionOfRecord> records = new ArrayList<CDescriptionOfRecord>();
        records.add(new CDescriptionOfRecord(CRecordAddAppFactory.ID, "AddAppFactory"));
        records.add(new CDescriptionOfRecord(CRecordRemoveAppFactory.ID, "RemoveAppFactory"));
        records.add(new CDescriptionOfRecord(CRecordLaunchApplication.ID, "LaunchApplication"));
        aDependencies.getHelperForLocalMicroServices().registerMicroService(CConstantsAppFactoryCollector.MICROSERVICE_ID, "Collector for Application Factories and Application Starter", records, aInstanceId, aAddress);
    }

    static void deregisterMicroservice(@NotNull IDependencies aDependencies, @NotNull IId aInstanceId) throws CException {
        aDependencies.getHelperForLocalMicroServices().deregisterMicroService(CConstantsAppFactoryCollector.MICROSERVICE_ID, aInstanceId);
    }

    static void registerTarget(@NotNull IDependencies aDependencies, @NotNull ITarget aTarget) throws CException {
        INamespace ns = aDependencies.getNamespaceFactory().createAndRegisterNamespace(CWellKnownNID.APP_REGISTRY, "AppRegistry");
        ns.getTargetRegistry().registerTarget(aTarget);
    }

    @NotNull
    public static List<CRecord> fill(@NotNull Collection<CApplicationFactoryEntry> aFactories, @Nullable String[] aRights, @NotNull String aPlatform) throws CException {
        ArrayList<CRecord> list = new ArrayList<CRecord>();
        String[] rights = aRights == null ? new String[]{} : aRights;
        for (CApplicationFactoryEntry entry : aFactories) {
            CApplicationEntry application = entry.getApplication();
            if (aRights == null || aRights.length <= 0 || !application.isStartingAllowed(rights) || !application.getPlatform().equalsIgnoreCase(aPlatform)) continue;
            CRecord record = CAppCollectorUtils.packApplication(application);
            list.add(record);
        }
        return list;
    }
}

