/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.software.updater.local;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.address.CSegmentId;
import de.sillysky.nyssr.cli.records.CRecordCliHandle;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.impl.software.updater.local.CUtilReboot;
import de.sillysky.nyssr.impl.software.updater.local.IDependencies;
import de.sillysky.nyssr.login.records.CRecordSessionValidate;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.network.nodeinfo.CNodeInfo;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.software.updater.records.CRecordReboot;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.cmdline.CCommandLineOption;
import de.sillysky.nyssr.util.cmdline.CCommandLineParser;
import de.sillysky.nyssr.util.cmdline.CFoundOption;
import de.sillysky.nyssr.util.cmdline.CFoundOptionList;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CTargetRebootNode
extends CTarget {
    private static final IId MICRO_SERVICE_SESSION = CIdFactory.fromObject((Object)"ccf168c1-f18b-4229-85f9-24461a19ee6a");
    private static final String RIGHT_SHUTDOWN = "NY_Shutdown";
    private final IDependencies mDependencies;
    private final CEnvelope mEnvelope;
    private final CRecord mRecord;
    private ScheduledExecutorService mScheduler;

    CTargetRebootNode(@NotNull IDependencies aDependencies, @NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        this.mDependencies = aDependencies;
        this.mEnvelope = aEnvelope;
        this.mRecord = aRecord;
        this.mEnvelope.setBlocked(true);
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordSessionValidate.ID, this::asyncAnswerValidate);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        String sessionToken = null;
        if (CRecordCliHandle.ID.equals((Object)this.mRecord.getId())) {
            sessionToken = CRecordCliHandle.getSessionToken((CRecord)this.mRecord, null);
        } else if (CRecordReboot.ID.equals((Object)this.mRecord.getId())) {
            sessionToken = CRecordReboot.getSessionToken((CRecord)this.mRecord, null);
        }
        if (sessionToken != null) {
            this.validate(sessionToken);
        } else {
            this.finish(2010, "Wrong message");
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncAnswerValidate(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            int resultCode = aEnvelope.getResultCode();
            if (resultCode == 0) {
                String token = CRecordSessionValidate.getToken((CRecord)aRecord, null);
                String[] rights = CRecordSessionValidate.getRights((CRecord)aRecord, null);
                boolean allowed = this.checkRights(rights);
                if (allowed) {
                    this.rebootNode(token);
                } else {
                    this.finish(5105, "Need right NY_Shutdown");
                }
            } else {
                this.finish(5108, "Unknown session token");
            }
            return true;
        }
        return false;
    }

    private void rebootNode(@NotNull String aSessionToken) throws CException {
        if (CRecordReboot.ID.equals((Object)this.mRecord.getId())) {
            ZonedDateTime time = CRecordReboot.getTime((CRecord)this.mRecord, null);
            int code = CRecordReboot.getCode((CRecord)this.mRecord, (int)0);
            this.doReboot(time == null ? null : time.toInstant(), code);
        } else if (CRecordCliHandle.ID.equals((Object)this.mRecord.getId())) {
            Object args;
            Instant time = null;
            String[] arguments = CRecordCliHandle.getArguments((CRecord)this.mRecord, null);
            if (arguments == null || arguments.length == 0) {
                this.doReboot(null, 1);
                return;
            }
            CCommandLineParser parser = new CCommandLineParser();
            parser.addOption(new CCommandLineOption("segment", false, false));
            parser.addOption(new CCommandLineOption("nodes", true, true));
            parser.addOption(new CCommandLineOption("in", true, false));
            parser.addOption(new CCommandLineOption("at", true, false));
            CFoundOptionList foundOptionList = parser.parseCommandLine(arguments);
            CFoundOption option = foundOptionList.getOption("at");
            if (option != null && !(args = option.getArguments()).isEmpty()) {
                String timeString = (String)args.get(0);
                time = CTargetRebootNode.convertStringToInstant(timeString);
            }
            if ((option = foundOptionList.getOption("in")) != null && !(args = option.getArguments()).isEmpty()) {
                String secondsString = (String)args.get(0);
                int seconds = Integer.parseInt(secondsString);
                time = Instant.now().plus((long)seconds, ChronoUnit.SECONDS);
            }
            if (time == null) {
                time = Instant.now();
            }
            if ((option = foundOptionList.getOption("segment")) == null) {
                option = foundOptionList.getOption("nodes");
                if (option == null) {
                    this.doReboot(time, 1);
                } else {
                    for (String argument : option.getArguments()) {
                        CNodeId nodeId = new CNodeId(argument);
                        CNodeAddress nodeAddress = new CNodeAddress(nodeId, CSegmentId.getLocal());
                        this.sendReboot(nodeAddress, aSessionToken, time, 1);
                    }
                    this.finish(0, "");
                }
            } else {
                Collection reachableNodes = this.mDependencies.getRouter().getReachableNodes();
                for (CNodeInfo nodeInfo : reachableNodes) {
                    CNodeAddress nodeAddress = nodeInfo.getNodeAddress();
                    if (!nodeAddress.getSegmentId().isLocal()) continue;
                    this.sendReboot(nodeAddress, aSessionToken, time, 1);
                }
            }
        }
    }

    private void doReboot(@Nullable Instant aTime, int aCode) throws CException {
        CUtilReboot.sendAnnounceReboot((ITarget)this, aTime);
        if (aTime == null || aTime.isBefore(Instant.now())) {
            System.out.println("reboot now");
            System.exit(aCode);
        } else {
            System.out.println("reboot at " + aTime);
            this.mScheduler = Executors.newScheduledThreadPool(1);
            long delay = Duration.between(Instant.now(), aTime).toMillis();
            this.mScheduler.schedule(() -> System.exit(aCode), delay, TimeUnit.MILLISECONDS);
            this.mScheduler.shutdown();
        }
    }

    private void sendReboot(@NotNull CNodeAddress aNodeAddress, @NotNull String aSessionToken, @Nullable Instant aTime, int aExitCode) throws CException {
        CEnvelope env = CEnvelope.forRemoteNanoService(CRecordReboot.class, (CNodeAddress)aNodeAddress);
        CRecord record = CRecordReboot.create();
        CRecordReboot.setSessionToken((CRecord)record, (String)aSessionToken);
        if (aTime != null) {
            CRecordReboot.setTime((CRecord)record, (ZonedDateTime)aTime.atZone(ZoneId.systemDefault()));
        }
        CRecordReboot.setCode((CRecord)record, (int)aExitCode);
        this.sendNotification(env, record);
    }

    private boolean checkRights(String[] aRights) {
        if (aRights != null) {
            for (String right : aRights) {
                if (!right.equalsIgnoreCase(RIGHT_SHUTDOWN)) continue;
                return true;
            }
        }
        return false;
    }

    private void validate(@NotNull String aSessionToken) throws CException {
        CEnvelope env = CEnvelope.forMicroService((IId)MICRO_SERVICE_SESSION);
        CRecord record = CRecordSessionValidate.create();
        CRecordSessionValidate.setToken((CRecord)record, (String)aSessionToken);
        this.sendRequest(env, record);
    }

    public static Instant convertStringToInstant(@NotNull String aTimeString) {
        LocalTime time = LocalTime.parse(aTimeString);
        LocalDate today = LocalDate.now();
        LocalTime now = LocalTime.now();
        LocalDateTime dateTime = now.isAfter(time) ? LocalDateTime.of(today.plusDays(1L), time) : LocalDateTime.of(today, time);
        return dateTime.atZone(ZoneId.systemDefault()).toInstant();
    }

    private void finish(int aCode, String aText) throws CException {
        this.mEnvelope.setResult(aCode, aText);
        this.mEnvelope.setBlocked(false);
        this.getMessageSender().sendBack(this.mEnvelope, this.mRecord);
        this.deregisterTarget();
    }
}

