/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.app.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordAppGetInstanceList
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"f752c93d-b74a-42bf-a65f-e7e22a9334e8");
    public static final String NAME = "AppGetInstanceList";
    public static final String DESCRIPTION = "Get a list of running application instances. The instances are listed as additional records of type CRecordApplicationInstance. Direction: Public --> App Instance Registry";
    public static final String SLOT_APP_INSTANCE_LIST = "1";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static CRecord[] getAppInstanceList(@NotNull CRecord aRecord, CRecord[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_APP_INSTANCE_LIST);
        if (slot == null) {
            return aDefault;
        }
        return (CRecord[])slot.getValue();
    }

    public static void setAppInstanceList(@NotNull CRecord aRecord, CRecord[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.RECORD_ARRAY, (Object)aValue);
        aRecord.addSlot(SLOT_APP_INSTANCE_LIST, slot);
    }
}

