/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.app.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.util.properties.CStringProperties;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public final class CRecordDataApplicationPreset
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"051c191f-289a-4feb-a29a-53a5c9285fdc");
    public static final String NAME = "DataApplicationPreset";
    public static final String DESCRIPTION = "An application preset.";
    public static final String SLOT_APPLICATION_ID = "2";
    public static final String SLOT_PRESET_NAME = "1";
    public static final String SLOT_PROPERTIES = "3";
    public static final String[] NAMESPACES = new String[0];
    public static final boolean IS_NANO_SERVICE = false;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static UUID getApplicationId(@NotNull CRecord aRecord, UUID aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_APPLICATION_ID);
        if (slot == null) {
            return aDefault;
        }
        return (UUID)slot.getValue();
    }

    public static String getPresetName(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_PRESET_NAME);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static CStringProperties getProperties(@NotNull CRecord aRecord, CStringProperties aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_PROPERTIES);
        if (slot == null) {
            return aDefault;
        }
        return (CStringProperties)slot.getValue();
    }

    public static void setApplicationId(@NotNull CRecord aRecord, UUID aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.UUID, (Object)aValue);
        aRecord.addSlot(SLOT_APPLICATION_ID, slot);
    }

    public static void setPresetName(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_PRESET_NAME, slot);
    }

    public static void setProperties(@NotNull CRecord aRecord, CStringProperties aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING_PROPERTIES, (Object)aValue);
        aRecord.addSlot(SLOT_PROPERTIES, slot);
    }
}

