/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.index.application;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.util.properties.CStringProperties;
import java.util.Objects;
import java.util.UUID;

public class CDtoListener {
    private final CTargetAddress mListener;
    private final UUID mApplicationId;
    private final CStringProperties mFilter;

    public CDtoListener(CTargetAddress aListener, UUID aApplicationId, CStringProperties aFilter) {
        this.mListener = aListener;
        this.mApplicationId = aApplicationId;
        this.mFilter = aFilter;
    }

    public boolean equals(Object aO) {
        if (this == aO) {
            return true;
        }
        if (aO == null || this.getClass() != aO.getClass()) {
            return false;
        }
        CDtoListener that = (CDtoListener)aO;
        if (!this.mListener.equals((Object)that.mListener)) {
            return false;
        }
        if (!Objects.equals(this.mApplicationId, that.mApplicationId)) {
            return false;
        }
        return Objects.equals(this.mFilter, that.mFilter);
    }

    public UUID getApplicationId() {
        return this.mApplicationId;
    }

    public CStringProperties getFilter() {
        return this.mFilter;
    }

    public CTargetAddress getListener() {
        return this.mListener;
    }

    public int hashCode() {
        int result = this.mListener.hashCode();
        result = 31 * result + (this.mApplicationId != null ? this.mApplicationId.hashCode() : 0);
        result = 31 * result + (this.mFilter != null ? this.mFilter.hashCode() : 0);
        return result;
    }

    boolean match(CTargetAddress aAddress, UUID aApplicationId, CStringProperties aFilter) {
        if (this.mListener.equals((Object)aAddress)) {
            return this.match(aApplicationId, aFilter);
        }
        return false;
    }

    boolean match(UUID aApplicationId, CStringProperties aFilter) {
        return (this.mApplicationId == null || this.mApplicationId.equals(aApplicationId)) && (this.mFilter == null || aFilter != null && aFilter.contains(this.mFilter));
    }
}

