/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.gatekeeper;

import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.gatekeeper.IGateKeeperRule;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.util.CUtilString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CRuleList {
    private final List<IGateKeeperRule> mRules = new ArrayList<IGateKeeperRule>();

    CRuleList() {
    }

    void add(IGateKeeperRule aRule) {
        this.mRules.add(aRule);
    }

    @NotNull
    Collection<IGateKeeperRule> getRules() {
        return new ArrayList<IGateKeeperRule>(this.mRules);
    }

    boolean match(int aGate, IId aMID, IId aReceiverNID, CNodeId aSenderNodeId) {
        boolean result = false;
        for (IGateKeeperRule r : this.mRules) {
            if (!r.match(aGate, aMID, aReceiverNID, aSenderNodeId)) continue;
            if (!r.isAllowRule()) {
                return false;
            }
            result = true;
        }
        return result;
    }

    @Nullable
    IGateKeeperRule removeRule(@NotNull String aDescription) {
        this.mRules.removeIf(next -> CUtilString.equals((String)aDescription, (String)next.getDescription()));
        return null;
    }

    int size() {
        return this.mRules.size();
    }
}

