/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.web.app.nodemanager;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.impl.web.app.nodemanager.CApplicationContext;
import de.sillysky.nyssr.impl.web.app.nodemanager.CRecordMainFinished;
import de.sillysky.nyssr.impl.web.app.nodemanager.IDependencies;
import de.sillysky.nyssr.impl.web.app.nodemanager.ILocalAppContext;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.web.dialog.records.CRecordShowWebDialog;
import de.sillysky.nyssr.remoteskin.web.dialog.records.CRecordWebNotifyDialogDismissed;
import de.sillysky.nyssr.remoteskin.web.protocol.CWebApi;
import de.sillysky.nyssr.remoteskin.web.protocol.CWebDialogApi;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebDeregisterWidgetOwner;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.CUtilUuid;
import de.sillysky.nyssr.web.dialog.login.CConstants;
import de.sillysky.nyssr.web.dialog.login.records.CRecordShowWebLoginDialog;
import de.sillysky.nyssr.web.dialog.login.records.CRecordWebLoginFinished;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CApp
extends CTarget
implements ILocalAppContext {
    private static final ILogger LOG = CLoggerFactory.getLogger(CApp.class);
    private static final IId MICRO_SERVICE_CURRENT_USER = CIdFactory.fromObject((Object)"NY_WebDialogCurrentUser_00315");
    private static final IId MICRO_SERVICE_MAIN_DIALOG = CIdFactory.fromObject((Object)"NY_WebDialogNodeManagerMain_00402");
    private static final String MAIN_WIDGET_ID = "rs_3a8b7318-0bb3-485b-af85-b527d2043882";
    private static final String ID_CURRENT_USER = "id_current_user";
    private static final String ID_MAIN_DIALOG = "id_00400_main";
    private final IDependencies mDependencies;
    private CApplicationContext mApplicationContext;
    private CTargetAddress mLoginDialogAddress;
    private CTargetAddress mMainDialog;
    private CWebApi mWebApi;
    private CWebDialogApi mWebDialogApi;

    CApp(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordShowWebLoginDialog.ID, this::asyncShowWebLoginDialog);
        this.addMessageHandler(CRecordWebLoginFinished.ID, this::asyncWebLoginFinished);
        this.addMessageHandler(CRecordMainFinished.ID, this::asyncMainFinished);
        this.addMessageHandler(CRecordWebNotifyDialogDismissed.ID, this::asyncWebDialogFinished);
        this.addMessageHandler(CRecordShowWebDialog.ID, this::asyncShowWebDialog);
    }

    void deactivate() throws CException {
        CTargetAddress remoteSkinClient = this.mApplicationContext.getClientRemoteSkinAddress();
        this.deregisterWidgetOwner(remoteSkinClient);
    }

    @Override
    @NotNull
    public CApplicationContext getApplicationContext() {
        return this.mApplicationContext;
    }

    @Override
    @NotNull
    public IDependencies getDependencies() {
        return this.mDependencies;
    }

    @Override
    public String getSessionToken() {
        return this.mApplicationContext.getSessionToken();
    }

    @Override
    public void setSessionToken(@Nullable String aSessionToken) {
        this.mApplicationContext.setSessionToken(aSessionToken);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        LOG.info("Web App UserManager started.");
        CTargetAddress remoteSkinClient = this.mApplicationContext.getClientRemoteSkinAddress();
        this.mWebApi = new CWebApi((ITarget)this, remoteSkinClient);
        this.mWebDialogApi = new CWebDialogApi((ITarget)this, remoteSkinClient);
        this.mWebApi.registerWidgets(new String[]{CUtilUuid.random().toString()});
        this.mApplicationContext.setApplicationAddress(this.getAddress());
        INamespace ns = this.mApplicationContext.getNamespace();
        if (ns != null) {
            if (CUtilString.isEmpty((String)this.mApplicationContext.getSessionToken())) {
                this.sendShowLoginDialog();
            } else {
                this.openDialogCurrentUser();
                this.showMainDialog();
            }
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncShowWebLoginDialog(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            int resultCode = aEnvelope.getResultCode();
            if (resultCode == 0) {
                this.mLoginDialogAddress = CRecordShowWebLoginDialog.getDialogTargetAddress((CRecord)aRecord, null);
            }
            return true;
        }
        return false;
    }

    private boolean asyncWebLoginFinished(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        int reason = CRecordWebLoginFinished.getReason((CRecord)aRecord, (int)1);
        this.mLoginDialogAddress = null;
        if (reason == 0) {
            String sessionToken = CRecordWebLoginFinished.getSessionToken((CRecord)aRecord, null);
            this.mApplicationContext.setSessionToken(sessionToken);
            if (CUtilString.isValid((String)sessionToken)) {
                this.openDialogCurrentUser();
            }
            this.showMainDialog();
        } else {
            this.sendShowLoginDialog();
        }
        return true;
    }

    private boolean asyncMainFinished(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.mMainDialog = null;
        this.sendShowLoginDialog();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncWebDialogFinished(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        IId microserviceId = CRecordWebNotifyDialogDismissed.getMicroserviceId((CRecord)aRecord, null);
        if (MICRO_SERVICE_CURRENT_USER.equals((Object)microserviceId)) {
            if (this.mMainDialog != null) {
                this.mWebDialogApi.dismissWebDialog(this.mMainDialog);
            }
            this.sendShowLoginDialog();
        } else if (MICRO_SERVICE_MAIN_DIALOG.equals((Object)microserviceId)) {
            this.mMainDialog = null;
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncShowWebDialog(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            IId microServiceId;
            if (aEnvelope.getResultCode() == 0 && MICRO_SERVICE_MAIN_DIALOG.equals((Object)(microServiceId = aEnvelope.getMicroServiceId()))) {
                this.mMainDialog = CRecordShowWebDialog.getDialogTargetAddress((CRecord)aRecord, null);
            }
            return true;
        }
        return false;
    }

    private void deregisterWidgetOwner(@NotNull CTargetAddress aAddress) throws CException {
        CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)aAddress);
        CRecord record = CRecordWebDeregisterWidgetOwner.create();
        this.sendNotification(env, record);
    }

    @NotNull
    CTargetAddress start(@NotNull CApplicationContext aContext) throws Exception {
        this.mApplicationContext = aContext;
        INamespace namespace = this.mApplicationContext.getNamespace();
        CUtilCheck.checkNotNull((Object)namespace, (String)"Namespace missing", (Object[])new Object[0]);
        return namespace.getTargetRegistry().registerTarget((ITarget)this);
    }

    private void openDialogCurrentUser() throws CException {
        this.mWebDialogApi.showWebDialog(MICRO_SERVICE_CURRENT_USER, this.mApplicationContext.getSessionToken(), ID_CURRENT_USER, null);
    }

    private void sendShowLoginDialog() throws CException {
        CEnvelope envelope = CEnvelope.forMicroService((IId)CConstants.MICRO_SERVICE_ID);
        CRecord record = CRecordShowWebLoginDialog.create();
        CRecordShowWebLoginDialog.setClientTargetAddress((CRecord)record, (CTargetAddress)this.mApplicationContext.getClientRemoteSkinAddress());
        CRecordShowWebLoginDialog.setOwnerTargetAddress((CRecord)record, (CTargetAddress)this.getAddress());
        CRecordShowWebLoginDialog.setParentWidgetId((CRecord)record, (String)MAIN_WIDGET_ID);
        this.sendRequest(envelope, record);
    }

    private void showMainDialog() throws CException {
        this.mWebDialogApi.showWebDialog(MICRO_SERVICE_MAIN_DIALOG, this.mApplicationContext.getSessionToken(), MAIN_WIDGET_ID, null);
    }
}

