/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events.border;

import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonInteger;
import de.sillysky.nyssr.remoteskin.model.events.CEventColor;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import de.sillysky.nyssr.remoteskin.model.events.border.EBorderType;
import de.sillysky.nyssr.remoteskin.model.events.border.IBorder;
import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventMatteBorder
implements IBorder,
IRemoteSkinEvent {
    private final int mTop;
    private final int mRight;
    private final int mBottom;
    private final int mLeft;
    private final Color mColor;

    public CEventMatteBorder(int aTop, int aRight, int aBottom, int aLeft, @NotNull Color aColor) {
        this.mTop = aTop;
        this.mRight = aRight;
        this.mBottom = aBottom;
        this.mLeft = aLeft;
        this.mColor = aColor;
    }

    @Nullable
    public static CEventMatteBorder create(@Nullable Object aValue) {
        CJsonObject jo;
        Object o;
        CEventColor dc;
        if (aValue instanceof CJsonObject && (dc = CEventColor.create(o = (jo = (CJsonObject)aValue).getValue(EKeys.color.name()))) != null) {
            int top = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)EKeys.top.name(), (int)0);
            int left = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)EKeys.left.name(), (int)0);
            int right = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)EKeys.right.name(), (int)0);
            int bottom = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)EKeys.bottom.name(), (int)0);
            return new CEventMatteBorder(top, right, bottom, left, dc.createColor());
        }
        return null;
    }

    public int getTop() {
        return this.mTop;
    }

    public int getRight() {
        return this.mRight;
    }

    public int getBottom() {
        return this.mBottom;
    }

    public int getLeft() {
        return this.mLeft;
    }

    public Color getColor() {
        return this.mColor;
    }

    @Override
    @NotNull
    public Border createBorder() {
        return BorderFactory.createMatteBorder(this.mTop, this.mLeft, this.mBottom, this.mRight, this.mColor);
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject(true);
        jo.put(EKeys.border_type.name(), (Object)this.getType().name());
        CEventColor dc = new CEventColor(this.mColor);
        jo.put(EKeys.color.name(), dc.toJson());
        jo.put(EKeys.top.name(), (Object)this.mTop);
        jo.put(EKeys.right.name(), (Object)this.mRight);
        jo.put(EKeys.bottom.name(), (Object)this.mBottom);
        jo.put(EKeys.left.name(), (Object)this.mLeft);
        return jo;
    }

    @Override
    public EBorderType getType() {
        return EBorderType.matte;
    }

    public static enum EKeys {
        border_type,
        top,
        left,
        bottom,
        right,
        color,
        icon;

    }
}

