/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.address.util;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class CTargetAddressList
implements Iterable<CTargetAddress> {
    private static final ILogger LOG = CLoggerFactory.getLogger(CTargetAddressList.class);
    private static int mNumber = 0;
    private final Set<CTargetAddress> mList = new CopyOnWriteArraySet<CTargetAddress>();
    private final String mName;

    public CTargetAddressList() {
        this.mName = Integer.toString(++mNumber);
    }

    public CTargetAddressList(String aName) {
        this.mName = aName;
    }

    public boolean add(CTargetAddress aAddress) {
        return this.mList.add(aAddress);
    }

    public void clear() {
        this.mList.clear();
    }

    public boolean contains(CTargetAddress aAddress) {
        return this.mList.contains(aAddress);
    }

    @Override
    public void forEach(Consumer<? super CTargetAddress> aAction) {
        this.mList.forEach(aAction);
    }

    public CTargetAddress[] getArray() {
        if (this.mList.isEmpty()) {
            return new CTargetAddress[0];
        }
        CTargetAddress[] arr = new CTargetAddress[this.mList.size()];
        arr = this.mList.toArray(arr);
        return arr;
    }

    public Collection<CTargetAddress> getList() {
        return new ArrayList<CTargetAddress>(this.mList);
    }

    @NotNull
    public Collection<CNodeAddress> getNodeList() {
        HashSet<CNodeAddress> set = new HashSet<CNodeAddress>();
        this.mList.forEach((? super T aAddress) -> set.add(aAddress.getNodeAddress()));
        return set;
    }

    public boolean isEmpty() {
        return this.mList.isEmpty();
    }

    @Override
    @NotNull
    public Iterator<CTargetAddress> iterator() {
        return this.mList.iterator();
    }

    public boolean remove(CTargetAddress aAddress) {
        boolean removed = this.mList.remove(aAddress);
        if (removed) {
            LOG.debug("Address removed: {}", aAddress.toString());
        }
        return removed;
    }

    public boolean removeAll(Collection<CTargetAddress> aCollection) {
        return this.mList.removeAll(aCollection);
    }

    public Collection<CTargetAddress> removeNamespace(IId aNID, CNodeAddress aNode) {
        LOG.debug("Remove local Namespace {} from TargetAddressList {}.", aNID, this.mName);
        ArrayList<CTargetAddress> toRemove = new ArrayList<CTargetAddress>();
        for (CTargetAddress address : this.mList) {
            CNodeAddress node = address.getNodeAddress();
            IId nid = address.getNID();
            if (!nid.equals(aNID) || !node.equals(aNode)) continue;
            toRemove.add(address);
        }
        toRemove.forEach(this.mList::remove);
        return toRemove;
    }

    public Collection<CTargetAddress> removeNode(CNodeAddress aNode) {
        LOG.debug("Remove node {} from TargetAddressList {}", aNode, this.mName);
        ArrayList<CTargetAddress> toRemove = new ArrayList<CTargetAddress>();
        for (CTargetAddress a : this.mList) {
            if (!aNode.equals(a.getNodeAddress())) continue;
            LOG.debug("Remove {} from TargetAddressList {}", a, this.mName);
            toRemove.add(a);
        }
        toRemove.forEach(this.mList::remove);
        return toRemove;
    }

    public int size() {
        return this.mList.size();
    }

    @Override
    public Spliterator<CTargetAddress> spliterator() {
        return this.mList.spliterator();
    }
}

