/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.exception;

import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.util.CUtilString;
import org.jetbrains.annotations.NotNull;

public class CUtilStackTrace {
    public static void printStackTrace(@NotNull StackTraceElement[] aStackTrace) {
        System.out.println("StackTrace:");
        for (int i = 1; i < aStackTrace.length; ++i) {
            StackTraceElement s = aStackTrace[i];
            System.out.println("\tat " + s.getClassName() + "." + s.getMethodName() + "(" + s.getFileName() + ":" + s.getLineNumber() + ")");
        }
    }

    public static void printStackTrace(@NotNull ILogger aLogger, @NotNull String aText, @NotNull StackTraceElement[] aStackTrace) {
        if (aLogger.isErrorEnabled()) {
            StringBuilder sb = new StringBuilder(1000);
            sb.append(aText).append(CUtilString.CRLF);
            for (int i = 1; i < aStackTrace.length; ++i) {
                StackTraceElement s = aStackTrace[i];
                sb.append("\tat ").append(s.getClassName()).append(".").append(s.getMethodName()).append("(").append(s.getFileName()).append(":").append(s.getLineNumber()).append(")");
            }
            aLogger.error(sb.toString());
        }
    }

    public static void printStackTrace() {
        CUtilStackTrace.printStackTrace(Thread.currentThread().getStackTrace());
    }

    private CUtilStackTrace() {
    }
}

