/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.id.widget;

import de.sillysky.nyssr.id.widget.CWidgetSetId;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.key.CUtilNormalize;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CWidgetId {
    @NotNull
    private final CWidgetSetId mWidgetSetId;
    @NotNull
    private final String mName;

    private CWidgetId(@NotNull CWidgetSetId aWidgetSetId, @NotNull String aName) {
        this.mWidgetSetId = aWidgetSetId;
        this.mName = aName;
    }

    @NotNull
    public static String valueToString(@Nullable CWidgetId aValue) {
        if (aValue == null) {
            return "null";
        }
        return aValue.valueToString();
    }

    @Nullable
    public static CWidgetId valueFromString(@Nullable String aValue) {
        if (CUtilString.isEmpty(aValue)) {
            return null;
        }
        return CWidgetId.create(aValue);
    }

    public static void toStream(@NotNull DataOutput aStream, @Nullable CWidgetId aValue) throws IOException {
        CUtilString.toStream(aStream, CWidgetId.valueToString(aValue));
    }

    @Nullable
    public static CWidgetId fromStream(@NotNull DataInput aStream) throws IOException {
        String s = CUtilString.fromStream(aStream);
        if (CUtilString.isEmpty(s)) {
            return null;
        }
        return CWidgetId.valueFromString(s);
    }

    @NotNull
    public static CWidgetId create(@Nullable String aWidgetName, @Nullable String aWidgetSetName, @Nullable String aInstance) {
        String widgetName = CUtilNormalize.normalize(aWidgetName);
        CWidgetSetId wsId = CWidgetSetId.create(aWidgetSetName, aInstance);
        return new CWidgetId(wsId, widgetName);
    }

    @NotNull
    public static CWidgetId create(@Nullable String aWidgetName, @Nullable CWidgetSetId aWidgetSetId) {
        String widgetName = CUtilNormalize.normalize(aWidgetName);
        CWidgetSetId wsId = aWidgetSetId;
        if (wsId == null) {
            wsId = CWidgetSetId.create("", "");
        }
        return new CWidgetId(wsId, widgetName);
    }

    @Nullable
    public static CWidgetId create(@Nullable String aValue) {
        if (CUtilString.isEmpty(aValue)) {
            return null;
        }
        String[] split = aValue.split("[.]");
        String wsName = null;
        String wsInst = null;
        String wName = null;
        if (split.length >= 1) {
            wName = split[0];
        }
        if (split.length >= 2) {
            wsName = split[1];
        }
        if (split.length >= 3) {
            wsInst = split[2];
        }
        return wsName == null || wName == null ? null : CWidgetId.create(wName, wsName, wsInst);
    }

    @NotNull
    public CWidgetSetId getWidgetSetId() {
        return this.mWidgetSetId;
    }

    @NotNull
    public String getName() {
        return this.mName;
    }

    public boolean equals(Object aO) {
        if (this == aO) {
            return true;
        }
        if (aO == null || this.getClass() != aO.getClass()) {
            return false;
        }
        CWidgetId cWidgetId = (CWidgetId)aO;
        return Objects.equals(this.mWidgetSetId, cWidgetId.mWidgetSetId) && Objects.equals(this.mName, cWidgetId.mName);
    }

    public int hashCode() {
        return Objects.hash(this.mWidgetSetId, this.mName);
    }

    public String valueToString() {
        return this.mName + "." + this.mWidgetSetId;
    }

    public boolean isValid() {
        return this.mWidgetSetId.isValid() && CUtilString.isValid(this.mName);
    }

    public String toString() {
        return this.valueToString();
    }
}

