/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.json.parser;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.json.parser.CContentHandler;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.json.IJsonParser;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.json.simple.parser.ContentHandler;
import org.json.simple.parser.JSONParser;

class CJsonParser
implements IService,
IJsonParser {
    private static final ILogger LOG = CLoggerFactory.getLogger(CJsonParser.class);

    CJsonParser() {
    }

    @Override
    public void activate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.registerService(IJsonParser.class, this);
    }

    @Override
    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.deregisterService(this);
    }

    @Override
    @NotNull
    public CJsonObject parse(@NotNull Path aPath, boolean aNormalizeKeys) throws CException {
        LOG.debug("Parse Json File {}", aPath);
        try {
            byte[] bytes = Files.readAllBytes(aPath);
            String text = new String(bytes, StandardCharsets.UTF_8);
            return this.parse(text, aNormalizeKeys);
        }
        catch (IOException e) {
            LOG.error(e, "Error parsing the JSON file {}", aPath);
            throw new CException(2105).append(e);
        }
    }

    @Override
    @NotNull
    public CJsonObject parse(@NotNull String aText, boolean aNormalizeKeys) throws CException {
        try {
            JSONParser parser = new JSONParser();
            CContentHandler ch = new CContentHandler(aNormalizeKeys);
            parser.parse(aText, (ContentHandler)ch);
            return ch.getResult();
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "Error parsing a JSON text");
            throw new CException(2105).append(e);
        }
    }
}

