/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.preferences;

import de.sillysky.nyssr.impl.preferences.CBackingStoreException;
import de.sillysky.nyssr.impl.preferences.CPreferences;
import de.sillysky.nyssr.impl.preferences.CPreferencesDescription;
import de.sillysky.nyssr.impl.preferences.CStreamBackingStore;
import de.sillysky.nyssr.impl.preferences.IBackingStoreManager;
import de.sillysky.nyssr.kernel.configuration.IKernelConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.prefs.Preferences;

public class CDataFileBackingStore
extends CStreamBackingStore {
    private final File mRootDirectory;

    CDataFileBackingStore(IKernelConfiguration aKernelConfiguration) {
        Preferences pref = aKernelConfiguration.getPreferences("preferences");
        String storageDir = pref.get("storage.dir", ".");
        this.mRootDirectory = new File(storageDir);
    }

    private static Boolean fileExists(File file) {
        return AccessController.doPrivileged(() -> file.exists() ? Boolean.TRUE : Boolean.FALSE);
    }

    private static FileInputStream getFileInputStream(File file) throws IOException {
        try {
            return AccessController.doPrivileged(() -> new FileInputStream(file));
        }
        catch (PrivilegedActionException e) {
            throw (FileNotFoundException)e.getException();
        }
    }

    private static FileOutputStream getFileOutputStream(File file) throws IOException {
        try {
            return AccessController.doPrivileged(() -> new FileOutputStream(file));
        }
        catch (PrivilegedActionException e) {
            throw (FileNotFoundException)e.getException();
        }
    }

    private static File[] getFilesList(File file) {
        return AccessController.doPrivileged(file::listFiles);
    }

    @Override
    public String[] availableOwners() {
        File[] children;
        try {
            this.checkAccess();
        }
        catch (CBackingStoreException ignore) {
            return new String[0];
        }
        HashSet<String> ownerIds = new HashSet<String>();
        for (File current : children = CDataFileBackingStore.getFilesList(this.mRootDirectory)) {
            CPreferencesDescription desc = this.getDescription(current);
            if (desc == null) continue;
            ownerIds.add(desc.getOwnerID());
        }
        return ownerIds.toArray(new String[0]);
    }

    @Override
    protected void checkAccess() throws CBackingStoreException {
        if (this.mRootDirectory == null) {
            throw new CBackingStoreException("Saving of data files to the bundle context is currently not supported.");
        }
    }

    private CPreferencesDescription getDescription(File aFile) {
        String fileName = aFile.getName();
        if (fileName.startsWith("P") && fileName.endsWith(".ser")) {
            String ownerID;
            String userID;
            String name = fileName.substring(1, fileName.length() - 4);
            int pos = name.indexOf("_");
            if (pos != -1) {
                userID = name.substring(pos + 1);
                ownerID = name.substring(0, pos);
            } else {
                ownerID = name;
                userID = null;
            }
            return new CPreferencesDescription(ownerID, userID);
        }
        return null;
    }

    private File getFile(CPreferencesDescription aDescription) {
        StringBuilder buffer = new StringBuilder("P");
        buffer.append(aDescription.getOwnerID());
        if (aDescription.getUserID() != null) {
            buffer.append('_');
            buffer.append(aDescription.getUserID());
        }
        buffer.append(".ser");
        return new File(this.mRootDirectory, buffer.toString());
    }

    @Override
    protected OutputStream getOutputStream(CPreferencesDescription aDescription) throws IOException {
        File file = this.getFile(aDescription);
        return CDataFileBackingStore.getFileOutputStream(file);
    }

    @Override
    public CPreferences load(IBackingStoreManager aManager, CPreferencesDescription aDescription) throws CBackingStoreException {
        this.checkAccess();
        File file = this.getFile(aDescription);
        if (CDataFileBackingStore.fileExists(file).booleanValue()) {
            try {
                CPreferences root = new CPreferences(aDescription, aManager);
                FileInputStream fis = CDataFileBackingStore.getFileInputStream(file);
                this.read(root, fis);
                fis.close();
                return root;
            }
            catch (IOException ioe) {
                throw new CBackingStoreException("Unable to load preferences.", ioe);
            }
        }
        return null;
    }

    @Override
    public CPreferences[] loadAll(IBackingStoreManager aManager, String aOwnerID) throws CBackingStoreException {
        this.checkAccess();
        ArrayList<CPreferences> list = new ArrayList<CPreferences>();
        File[] children = CDataFileBackingStore.getFilesList(this.mRootDirectory);
        if (children != null) {
            for (File current : children) {
                CPreferencesDescription desc = this.getDescription(current);
                if (desc == null || !desc.getOwnerID().equals(aOwnerID)) continue;
                CPreferences root = new CPreferences(desc, aManager);
                try {
                    FileInputStream fis = CDataFileBackingStore.getFileInputStream(current);
                    this.read(root, fis);
                    fis.close();
                }
                catch (IOException ioe) {
                    throw new CBackingStoreException("Unable to load preferences.", ioe);
                }
                list.add(root);
            }
        }
        return list.toArray(new CPreferences[0]);
    }

    @Override
    public void remove(String aOwnerID) throws CBackingStoreException {
        File[] children;
        this.checkAccess();
        for (File current : children = CDataFileBackingStore.getFilesList(this.mRootDirectory)) {
            CPreferencesDescription desc = this.getDescription(current);
            if (desc == null || !desc.getOwnerID().equals(aOwnerID)) continue;
            current.delete();
        }
    }
}

