/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.slot;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISingleSlotTypeFactory;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.slot.ISlotFactory;
import de.sillysky.nyssr.util.CPositiveInteger;
import de.sillysky.nyssr.util.CUtilString;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CSlotFactory
implements ISlotFactory {
    private static final ILogger LOG = CLoggerFactory.getLogger(CSlotFactory.class);
    private final Map<CSlotType, ISingleSlotTypeFactory> mFactories = new ConcurrentHashMap<CSlotType, ISingleSlotTypeFactory>(50);
    private final Map<Integer, ISingleSlotTypeFactory> mFactoriesByType = new ConcurrentHashMap<Integer, ISingleSlotTypeFactory>(50);
    private final Map<String, ISingleSlotTypeFactory> mFactoriesByName = new ConcurrentHashMap<String, ISingleSlotTypeFactory>(50);

    @Override
    public ISlot create(@NotNull CSlotType aType) throws CException {
        return this.fromObject(aType, null);
    }

    @Override
    public ISlot fromObject(CSlotType aType, Object aValue) throws CException {
        ISingleSlotTypeFactory factory = this.getFactory(aType);
        if (factory == null) {
            throw new CException(2007).append("The slot type ").append(aType).append(" is unknown.");
        }
        return factory.fromObject(aType, aValue);
    }

    @Override
    public ISlot fromObject(@Nullable Object aValue) {
        ISlot slot = null;
        if (aValue == null) {
            LOG.error("Error creating a slot of unknown type with a null value only.");
        } else {
            Class<?> class1 = aValue.getClass();
            for (ISingleSlotTypeFactory sf : this.mFactories.values()) {
                Class<?> class2 = sf.getClassOfProducedObject();
                if (!class1.equals(class2)) continue;
                slot = sf.fromObject(sf.getType(), aValue);
                break;
            }
            if (slot == null) {
                LOG.error("Error creating a slot because no matching factory has been registered.");
            }
        }
        return slot;
    }

    @Override
    @Nullable
    public ISlot fromStream(@NotNull DataInput aStream) throws IOException {
        int typeOrdinal = CPositiveInteger.fromStream(aStream);
        int length = CPositiveInteger.fromStream(aStream);
        ISingleSlotTypeFactory f = this.mFactoriesByType.get(typeOrdinal);
        if (f == null) {
            this.skip(aStream, length);
        } else {
            DataInputStream dis;
            if (aStream instanceof DataInputStream) {
                dis = (DataInputStream)aStream;
                dis.mark(Short.MAX_VALUE);
            } else {
                dis = null;
            }
            CSlotType type = f.getType();
            try {
                return f.readSlot(aStream, type);
            }
            catch (Exception e) {
                if (dis != null) {
                    dis.reset();
                    this.skip(aStream, length);
                }
                throw e;
            }
        }
        return null;
    }

    @Override
    public void deregisterFactory(@NotNull CSlotType aType) {
        this.mFactories.remove(aType);
        this.mFactoriesByType.remove(aType.getId());
        this.mFactoriesByName.remove(aType.getName());
    }

    @Override
    public void deregisterFactory(@NotNull CSlotType aType, @NotNull ISingleSlotTypeFactory aFactory) {
        if (this.mFactories.containsKey(aType)) {
            this.mFactories.remove(aType);
            this.mFactoriesByType.remove(aType.getId());
            this.mFactoriesByName.remove(aType.getName());
        }
    }

    private ISingleSlotTypeFactory getFactory(@NotNull CSlotType aType) {
        ISingleSlotTypeFactory factory = this.mFactories.get(aType);
        if (factory == null) {
            LOG.error("No Factory {} registered.", aType);
        }
        return factory;
    }

    @Override
    @Nullable
    public CSlotType getSlotTypeByName(@Nullable String aName) {
        ISingleSlotTypeFactory f;
        if (!CUtilString.isEmpty(aName) && (f = this.mFactoriesByName.get(aName)) != null) {
            return f.getType();
        }
        return null;
    }

    @Override
    @Nullable
    public CSlotType getSlotTypeByOrdinal(int aOrdinal) {
        ISingleSlotTypeFactory f = this.mFactoriesByType.get(aOrdinal);
        if (f != null) {
            return f.getType();
        }
        return null;
    }

    @Override
    public void registerFactory(@NotNull CSlotType aType, @NotNull ISingleSlotTypeFactory aFactory) {
        if (!this.mFactories.containsKey(aType)) {
            LOG.info("Register SlotFactory for {}.", aFactory.getType());
            this.mFactories.put(aType, aFactory);
            this.mFactoriesByType.put(aType.getId(), aFactory);
            this.mFactoriesByName.put(aType.getName(), aFactory);
        }
    }

    private void skip(@NotNull DataInput aStream, int aLength) throws IOException {
        int read;
        int bytesToSkip = aLength;
        int skippedBytes = 0;
        do {
            if ((read = aStream.skipBytes(bytesToSkip)) <= 0) continue;
            bytesToSkip -= read;
            skippedBytes += read;
        } while (read >= 0 && skippedBytes < aLength);
    }

    @Override
    public void toStream(@NotNull DataOutput aStream, @NotNull ISlot aSlot) throws IOException {
        int ordinal = aSlot.getType().getId();
        CPositiveInteger.toStream(aStream, ordinal);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(200);
        DataOutputStream dos = new DataOutputStream(bos);
        aSlot.toStream(dos);
        dos.flush();
        byte[] data = bos.toByteArray();
        CPositiveInteger.toStream(aStream, data.length);
        aStream.write(data);
    }

    @Override
    @Contract(pure=true)
    @Nullable
    public ISlot fromJson(@NotNull CSlotType aSlotType, @NotNull Object aValue, @NotNull Map<Integer, byte[]> aByteArrayStore) {
        ISingleSlotTypeFactory f = this.mFactories.get(aSlotType);
        if (f != null) {
            return f.fromJson(aValue, aByteArrayStore);
        }
        return null;
    }
}

