/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.target.listener;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.address.util.CTargetAddressList;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.id.common.CWellKnownTID;
import de.sillysky.nyssr.kernel.configuration.IKernelConfiguration;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.CMessage;
import de.sillysky.nyssr.message.IMessageSender;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.listener.IListenerRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CListenerRegistry
implements IListenerRegistry,
IService {
    private static final ILogger LOG = CLoggerFactory.getLogger(CListenerRegistry.class);
    private static final ILogger LOG_ONLY_LOCAL = CLoggerFactory.getLogger("onlylocal");
    private static final int HASH_MAP_SIZE = 400;
    private Map<UUID, CTargetAddressList> mAddresses;
    private CTargetAddress mAddress;
    private CNodeAddress mNodeAddress;
    private IMessageSender mMessageSender;

    CListenerRegistry() {
    }

    public static void getDependencies(@NotNull IServiceDependencyList aDependencyList) {
        aDependencyList.add(IKernelConfiguration.class);
        aDependencyList.add(IMessageSender.class);
    }

    @Override
    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        LOG.debug("Activate {}", this.getClass().getSimpleName());
        IKernelConfiguration kernelConfiguration = aServiceRegistry.getService(IKernelConfiguration.class);
        assert (kernelConfiguration != null);
        this.mNodeAddress = kernelConfiguration.getNodeAddress();
        this.mMessageSender = aServiceRegistry.getService(IMessageSender.class);
        this.mAddresses = new ConcurrentHashMap<UUID, CTargetAddressList>(400);
        this.mAddress = new CTargetAddress(CWellKnownTID.LISTENER_REGISTRY, CWellKnownNID.SYSTEM, this.mNodeAddress);
        aServiceRegistry.registerService(IListenerRegistry.class, this);
    }

    @Override
    public boolean addAddress(@NotNull UUID aRequesterId, @NotNull CTargetAddress aListener) {
        boolean result;
        CTargetAddressList list = this.mAddresses.get(aRequesterId);
        if (list == null) {
            list = new CTargetAddressList(aRequesterId.toString());
            this.mAddresses.put(aRequesterId, list);
        }
        if (result = list.add(aListener)) {
            LOG_ONLY_LOCAL.debug("Listener added: Type={}, Listener={}", aRequesterId, aListener);
        }
        return result;
    }

    @Override
    @NotNull
    public CTargetAddress[] clear(@NotNull UUID aRequesterId) {
        CTargetAddressList removed = this.mAddresses.remove(aRequesterId);
        return removed == null ? new CTargetAddress[]{} : removed.getArray();
    }

    @Override
    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.deregisterService(this);
    }

    public void deactivate() {
        this.mMessageSender = null;
    }

    @Override
    @NotNull
    public CTargetAddress[] getAddresses(@NotNull UUID aRequesterId) {
        CTargetAddressList list = this.mAddresses.get(aRequesterId);
        return list == null ? new CTargetAddress[]{} : list.getArray();
    }

    @Override
    @NotNull
    public Collection<CTargetAddress> getListenerList(@NotNull UUID aRequesterId) {
        CTargetAddressList list = this.mAddresses.get(aRequesterId);
        return list == null ? new ArrayList() : list.getList();
    }

    @Override
    public int getNumberOfListener(@NotNull UUID aRequesterId) {
        CTargetAddressList list = this.mAddresses.get(aRequesterId);
        return list == null ? 0 : list.size();
    }

    @Override
    @Nullable
    public CTargetAddressList getTargetAddressList(@NotNull UUID aRequesterId) {
        return this.mAddresses.get(aRequesterId);
    }

    @Override
    public boolean hasAddress(@NotNull UUID aRequesterId, @NotNull CTargetAddress aAddress) {
        CTargetAddressList list = this.mAddresses.get(aRequesterId);
        if (list != null) {
            return list.contains(aAddress);
        }
        return false;
    }

    @Override
    public void notifyLocalNamespaceRemoved(@NotNull IId aNID) {
        LOG_ONLY_LOCAL.debug("Remove local Namespace {}.", aNID);
        for (CTargetAddressList list : this.mAddresses.values()) {
            list.removeNamespace(aNID, this.mNodeAddress);
        }
    }

    @Override
    public void notifyNodeRemoved(@NotNull CNodeAddress aNode) {
        for (CTargetAddressList list : this.mAddresses.values()) {
            list.removeNode(aNode);
        }
    }

    @Override
    public void notifyTargetRemoved(@NotNull CTargetAddress aAddress) {
        LOG.debug("Remove Target {}.", aAddress);
        for (CTargetAddressList list : this.mAddresses.values()) {
            list.remove(aAddress);
        }
    }

    @Override
    public boolean removeAddress(@NotNull UUID aRequesterId, @NotNull CTargetAddress aListener) {
        CTargetAddressList list = this.mAddresses.get(aRequesterId);
        return list != null && list.remove(aListener);
    }

    private void send(@NotNull UUID aRequesterId, @NotNull CMessage aMsg, boolean aIsRequest) {
        CTargetAddressList list = this.mAddresses.get(aRequesterId);
        if (list == null) {
            return;
        }
        CEnvelope env = aMsg.getEnvelope();
        ArrayList<CTargetAddress> removeList = null;
        int number = 0;
        for (CTargetAddress listener : list) {
            CNodeAddress nodeAddress;
            if (env.isOnlyLocal() && !(nodeAddress = listener.getNodeAddress()).equals(this.mNodeAddress)) continue;
            CMessage msg = number < list.size() - 1 ? new CMessage(aMsg) : aMsg;
            msg.getEnvelope().setReceiver(listener);
            try {
                if (aIsRequest) {
                    this.mMessageSender.send(msg);
                } else {
                    msg.getEnvelope().setSender(this.mAddress);
                    this.mMessageSender.sendNotification(msg);
                }
            }
            catch (CException e) {
                String s = aIsRequest ? "request" : "notification";
                LOG_ONLY_LOCAL.warn("Could not send {}: {}", s, e.getMessage());
                LOG.debug("Remove Listener {} from list {}.", listener, aRequesterId);
                if (removeList == null) {
                    removeList = new ArrayList<CTargetAddress>();
                }
                removeList.add(listener);
            }
            ++number;
        }
        if (removeList != null) {
            list.removeAll(removeList);
        }
    }

    @Override
    public void sendNotification(@NotNull UUID aRequesterId, @NotNull CMessage aNotification) {
        this.send(aRequesterId, aNotification, false);
    }

    @Override
    public void sendRequest(@NotNull UUID aRequesterId, @NotNull CMessage aRequest) {
        this.send(aRequesterId, aRequest, true);
    }
}

