/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.job.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordNotifyJobFinished
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject("cf854cf1-cdc6-457d-b3b5-0a9100aa4739");
    public static final String NAME = "NotifyJobFinished";
    public static final String DESCRIPTION = "Notification: A job has been finished.";
    public static final String SLOT_ELAPSED_TIME = "3";
    public static final String SLOT_JOB_NAME = "2";
    public static final String SLOT_THREAD_QUEUE_ID = "1";
    public static final String[] NAMESPACES = new String[0];
    public static final boolean IS_NANO_SERVICE = false;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static long getElapsedTime(@NotNull CRecord aRecord, long aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_ELAPSED_TIME);
        if (slot == null) {
            return aDefault;
        }
        return (Long)slot.getValue();
    }

    public static String getJobName(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_JOB_NAME);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static IId getThreadQueueId(@NotNull CRecord aRecord, IId aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_THREAD_QUEUE_ID);
        if (slot == null) {
            return aDefault;
        }
        return (IId)slot.getValue();
    }

    public static void setElapsedTime(@NotNull CRecord aRecord, long aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.LONG, aValue);
        aRecord.addSlot(SLOT_ELAPSED_TIME, slot);
    }

    public static void setJobName(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.STRING, aValue);
        aRecord.addSlot(SLOT_JOB_NAME, slot);
    }

    public static void setThreadQueueId(@NotNull CRecord aRecord, IId aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.ID, aValue);
        aRecord.addSlot(SLOT_THREAD_QUEUE_ID, slot);
    }
}

