/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util;

import de.sillysky.nyssr.util.CUtilObject;
import de.sillysky.nyssr.util.CUtilString;
import org.jetbrains.annotations.NotNull;

public final class CUtilObjectArray {
    private CUtilObjectArray() {
    }

    @NotNull
    public static String toString(Object[] aValue) {
        String result;
        if (aValue == null) {
            result = "null";
        } else {
            StringBuilder sb = new StringBuilder(200);
            sb.append('[');
            sb.append(aValue.length);
            sb.append(']');
            boolean first = true;
            for (Object element : aValue) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append(CUtilObject.toString(element));
            }
            result = sb.toString();
        }
        return result;
    }

    public static String toString(Object[] aValue, int aMaxLen) {
        String result;
        if (aValue == null) {
            result = "null";
            result = CUtilString.shortenString(result, aMaxLen);
        } else {
            StringBuffer sb = new StringBuffer(200);
            int size = aValue.length;
            sb.append('[');
            sb.append(size);
            sb.append(']');
            for (Object element : aValue) {
                sb.append('[');
                sb.append(CUtilObject.toString(element));
                sb.append(']');
                if (sb.length() >= aMaxLen) break;
            }
            result = CUtilString.getShortenString(sb, aMaxLen);
        }
        return result;
    }

    @NotNull
    public static String toString(Object[] aValue, @NotNull String aDelimiter) {
        String result;
        if (aValue == null) {
            result = "";
        } else {
            StringBuilder sb = new StringBuilder(aValue.length * 20);
            boolean first = true;
            for (Object element : aValue) {
                if (first) {
                    first = false;
                } else {
                    sb.append(aDelimiter);
                }
                sb.append(element.toString());
            }
            result = sb.toString();
        }
        return result;
    }
}

