/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util;

import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.util.CPositiveInteger;
import de.sillysky.nyssr.util.CUtilRandom;
import de.sillysky.nyssr.util.CUtilShort;
import de.sillysky.nyssr.util.array.CUtilArray;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CUtilShortArray {
    public static final short[] EMPTY = new short[0];
    private static final int ITEM_STRING_LENGTH = 6;
    private static final ILogger LOG = CLoggerFactory.getLogger(CUtilShortArray.class);

    private CUtilShortArray() {
    }

    public static short @Nullable [] copy(short @Nullable [] aValue) {
        if (aValue == null) {
            return null;
        }
        if (aValue.length == 0) {
            return EMPTY;
        }
        return Arrays.copyOf(aValue, aValue.length);
    }

    public static short @Nullable [] fromList(@Nullable List<?> aValue) {
        if (aValue == null) {
            return null;
        }
        if (aValue.isEmpty()) {
            return EMPTY;
        }
        ArrayList<Short> list = new ArrayList<Short>();
        for (Object element : aValue) {
            short[] sArray;
            if (element == null) continue;
            if (element instanceof Short) {
                Short e = (Short)element;
                list.add(e);
                continue;
            }
            if (element instanceof Short[]) {
                Short[] ee2 = (Short[])element;
                Collections.addAll(list, ee2);
                continue;
            }
            if (element instanceof short[]) {
                short[] ee;
                for (short e : ee = (short[])element) {
                    list.add(e);
                }
                continue;
            }
            if (!(element instanceof String)) continue;
            String s = (String)element;
            for (short e : sArray = CUtilShortArray.fromString(s)) {
                list.add(e);
            }
        }
        short[] arr = new short[list.size()];
        int pos = 0;
        for (Short s : list) {
            arr[pos] = s;
            ++pos;
        }
        return arr;
    }

    public static short @Nullable [] fromStream(@NotNull DataInput aStream) throws IOException {
        int len = CPositiveInteger.fromStream(aStream);
        if (len == 0) {
            return null;
        }
        short[] value = new short[len - 1];
        for (int i = 0; i < len - 1; ++i) {
            value[i] = aStream.readShort();
        }
        return value;
    }

    public static short @NotNull [] random(int aLength) {
        short[] array = new short[aLength];
        for (int i = 0; i < aLength; ++i) {
            array[i] = (short)CUtilRandom.getRandom().nextInt();
        }
        return array;
    }

    public static short @NotNull [] fromString(String aValue) {
        return CUtilShortArray.fromString(aValue, ",");
    }

    public static short @NotNull [] fromString(@Nullable String aValue, @NotNull String aDelimiter) {
        short[] arr;
        if (aValue == null || aValue.isEmpty() || aValue.trim().isEmpty()) {
            arr = new short[]{};
        } else {
            String[] tokens = aValue.split(aDelimiter, -1);
            arr = new short[tokens.length];
            for (int i = 0; i < tokens.length; ++i) {
                arr[i] = CUtilShort.fromString(tokens[i]);
            }
        }
        return arr;
    }

    public static boolean isEqual(short @Nullable [] aValue1, short @Nullable [] aValue2) {
        return Arrays.equals(aValue1, aValue2);
    }

    public static boolean isEqual(short @Nullable [] aValue1, Short @Nullable [] aValue2) {
        if (aValue1 == null) {
            return aValue2 == null;
        }
        if (aValue2 == null) {
            return false;
        }
        for (int i = 0; i < aValue1.length; ++i) {
            if (aValue1[i] == aValue2[i]) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static String toString(short @Nullable [] aValue, char aDelimiter, int aMaxLen) {
        if (aValue == null) {
            return "null";
        }
        return CUtilArray.toString(0, aDelimiter, aMaxLen, index -> index >= aValue.length ? "\uf00bE" : Short.toString(aValue[index]));
    }

    public static void toStream(@NotNull DataOutput aStream, short @Nullable [] aValue) throws IOException {
        if (aValue == null) {
            CPositiveInteger.toStream(aStream, 0);
        } else {
            CPositiveInteger.toStream(aStream, aValue.length + 1);
            for (short element : aValue) {
                aStream.writeShort(element);
            }
        }
    }

    public static List<Short> toList(short @Nullable [] aValues1) {
        return CUtilShortArray.toList(aValues1, new ArrayList<Short>());
    }

    public static List<Short> toList(short @Nullable [] aValues1, @NotNull List<Short> aList) {
        if (aValues1 != null) {
            for (short i : aValues1) {
                aList.add(i);
            }
        }
        return aList;
    }
}

