/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.resources;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CUtilResources {
    private static final ILogger LOG = CLoggerFactory.getLogger(CUtilResources.class);
    private static final int CHUNK_LEN = 1000;

    private CUtilResources() {
    }

    @NotNull
    public static String getStringResource(@NotNull Class<?> aReferenceClass, @NotNull String aPath) throws CException {
        CUtilCheck.checkNotNull(aReferenceClass, "Missing reference class.", new Object[0]);
        CUtilCheck.checkEmptyString(aPath, "Missing Path.", new Object[0]);
        try {
            URL url = aReferenceClass.getResource(aPath);
            Path path = Paths.get(url.toURI());
            byte[] bytes = Files.readAllBytes(path);
            return new String(bytes, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new CException(2).append(e);
        }
    }

    @Nullable
    public static File getFile(@NotNull Class<?> aReferenceClass, @NotNull String aPath) {
        String file;
        URL resource = aReferenceClass.getClassLoader().getResource(aPath);
        if (resource != null && (file = resource.getFile()) != null) {
            return new File(file);
        }
        return null;
    }

    public static String readTextFile(Class aClass, String aPath, Charset aEncoding) {
        String str;
        try {
            int bytesRead;
            InputStream is = aClass.getResourceAsStream(aPath);
            BufferedInputStream bis = new BufferedInputStream(is);
            int len = 0;
            byte[] contents = new byte[1000];
            ArrayList<byte[]> list = new ArrayList<byte[]>();
            do {
                if ((bytesRead = bis.read(contents)) == -1) continue;
                byte[] store = new byte[bytesRead];
                System.arraycopy(contents, 0, store, 0, bytesRead);
                list.add(store);
                len += bytesRead;
            } while (bytesRead != -1);
            byte[] bb = new byte[len];
            int offset = 0;
            for (byte[] b : list) {
                System.arraycopy(b, 0, bb, offset, b.length);
                offset += b.length;
            }
            str = new String(bb, aEncoding);
            bis.close();
        }
        catch (Exception e) {
            LOG.error(e, "Error reading from File {}", aPath);
            str = "";
        }
        return str;
    }
}

