/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.time;

import de.sillysky.nyssr.util.time.CUtilInstant;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CUtilLocalDateTime {
    private CUtilLocalDateTime() {
    }

    public static void toStream(@NotNull DataOutput aStream, @Nullable LocalDateTime aLocalDateTime) throws IOException {
        Instant i = CUtilInstant.fromLocalDateTime(aLocalDateTime);
        CUtilInstant.toStream(aStream, i);
    }

    @NotNull
    public static LocalDateTime fromInstant(@NotNull Instant aInstant) {
        return LocalDateTime.ofInstant(aInstant, ZoneOffset.UTC);
    }

    @Nullable
    public static LocalDateTime fromStream(@NotNull DataInput aStream) throws IOException {
        Instant instant = CUtilInstant.fromStream(aStream);
        return instant == null ? null : CUtilLocalDateTime.fromInstant(instant);
    }

    @Nullable
    public static Object toJson(@Nullable LocalDateTime aLocalDateTime) {
        if (aLocalDateTime != null) {
            // empty if block
        }
        return null;
    }

    @Nullable
    public static LocalDateTime fromTimestamp(@Nullable Timestamp aTimestamp) {
        return aTimestamp == null ? null : aTimestamp.toLocalDateTime();
    }

    @NotNull
    public static String toString(@NotNull LocalDateTime aDateTime) {
        return aDateTime.format(DateTimeFormatter.ISO_DATE_TIME);
    }

    @Nullable
    public static LocalDateTime fromString(@NotNull String aStr, @NotNull String aFormat) {
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(aFormat).withResolverStyle(ResolverStyle.LENIENT);
            LocalDateTime ldt = LocalDateTime.parse(aStr, formatter);
            return ldt;
        }
        catch (Exception formatter) {
            try {
                DateTimeFormatter formatter2 = DateTimeFormatter.ofPattern(aFormat).withResolverStyle(ResolverStyle.LENIENT);
                LocalDateTime ldt = LocalDate.parse(aStr, formatter2).atStartOfDay();
                return ldt;
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    @NotNull
    public static LocalDateTime fromString(@NotNull String aStr) {
        return LocalDateTime.parse(aStr, DateTimeFormatter.ISO_DATE_TIME);
    }

    @NotNull
    public static LocalDateTime fromDate(@NotNull Date aDate) {
        return aDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static long getLocalMillis(@NotNull LocalDateTime aTime) {
        return aTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static long toUtcMillis(@NotNull LocalDateTime aTime) {
        ZonedDateTime zdt = aTime.atZone(ZoneOffset.UTC);
        return zdt.toInstant().toEpochMilli();
    }

    public static long diffInMillis(LocalDateTime aStartTime) {
        return ChronoUnit.MILLIS.between(aStartTime, LocalDateTime.now());
    }
}

