/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.dialog.user;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.id.widget.CWidgetSetId;
import de.sillysky.nyssr.impl.dialog.user.CMainTarget;
import de.sillysky.nyssr.remoteskin.model.events.CEventButtonPressedNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventTextChangeNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventWindowNotification;
import de.sillysky.nyssr.remoteskin.server.context.IRemoteSkinServerContext;
import de.sillysky.nyssr.remoteskin.server.context.IWidgetApi;
import de.sillysky.nyssr.remoteskin.server.listeners.IButtonPressedListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IListener;
import de.sillysky.nyssr.remoteskin.server.listeners.ITextChangeListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IWindowClosingListener;
import de.sillysky.nyssr.util.CUtilString;
import org.jetbrains.annotations.NotNull;

class C705Handler {
    private final CMainTarget mMainTarget;
    private final IRemoteSkinServerContext mServerContext;
    private final IWidgetApi mApi;
    private final CWidgetSetId mWs705;
    private final CWidgetId m705Dialog;
    private final CWidgetId m705TfRight;
    private final CWidgetId m705TfDescription;
    private final CWidgetId m705ButtonOkay;
    private final CWidgetId m705ButtonCancel;
    private String mRight = "";
    private String mDescription = "";
    private boolean m705ButtonOkayIsEnabled;
    private boolean m705open;
    private CWidgetId mParentWidget;

    C705Handler(@NotNull CMainTarget aMainTarget, @NotNull IRemoteSkinServerContext aServerContext, @NotNull String aInstance) {
        this.mMainTarget = aMainTarget;
        this.mServerContext = aServerContext;
        this.mApi = this.mServerContext.getWidgetApi();
        this.mWs705 = CWidgetSetId.create((String)"@705_AddRight", (String)aInstance);
        this.m705Dialog = CWidgetId.create((String)"#705_Dialog", (CWidgetSetId)this.mWs705);
        this.mApi.addListener(this.m705Dialog, (IListener)((IWindowClosingListener)this::onDialogClosing));
        this.m705TfRight = CWidgetId.create((String)"#705_TextFieldRight", (CWidgetSetId)this.mWs705);
        this.mApi.addListener(this.m705TfRight, (IListener)((ITextChangeListener)this::onTextChangeRight));
        this.m705TfDescription = CWidgetId.create((String)"#705_TextFieldDescription", (CWidgetSetId)this.mWs705);
        this.mApi.addListener(this.m705TfDescription, (IListener)((ITextChangeListener)this::onTextChangeDescription));
        this.m705ButtonOkay = CWidgetId.create((String)"#705_ButtonOkay", (CWidgetSetId)this.mWs705);
        this.mApi.addListener(this.m705ButtonOkay, (IListener)((IButtonPressedListener)this::onButtonOkay));
        this.m705ButtonCancel = CWidgetId.create((String)"#705_ButtonCancel", (CWidgetSetId)this.mWs705);
        this.mApi.addListener(this.m705ButtonCancel, (IListener)((IButtonPressedListener)this::onButtonCancel));
    }

    private void onTextChangeRight(@NotNull CEventTextChangeNotification aEvent) {
        this.mRight = aEvent.getText();
        this.checkButtonOkay();
    }

    private void onTextChangeDescription(@NotNull CEventTextChangeNotification aEvent) {
        this.mDescription = aEvent.getText();
    }

    private void onDialogClosing(@NotNull CEventWindowNotification aWindowEvent) {
        this.unmount();
    }

    void mount(@NotNull CWidgetId aParentWidget) {
        if (!this.m705open) {
            this.m705open = true;
            this.mParentWidget = aParentWidget;
            this.m705ButtonOkayIsEnabled = false;
            this.mServerContext.mountWidgetSet(this.mWs705, this.mParentWidget, "#705_PanelBackground", this::widgetSetMounted);
            this.sendUpdate();
        }
    }

    private void checkButtonOkay() {
        boolean enabled = CUtilString.isValid((String)this.mRight);
        if (this.m705ButtonOkayIsEnabled != enabled) {
            this.m705ButtonOkayIsEnabled = enabled;
            this.mApi.setEnabled(this.m705ButtonOkay, enabled);
            this.sendUpdate();
        }
    }

    private void widgetSetMounted(@NotNull CWidgetSetId aWidgetSetId) {
        if (this.mWs705.equals((Object)aWidgetSetId)) {
            this.mApi.pack(this.m705Dialog);
            this.mApi.centerWidget(this.m705Dialog, this.mParentWidget);
            this.mApi.setVisible(this.m705Dialog, true);
            this.sendUpdate();
        }
    }

    void unmount() {
        if (this.m705open) {
            this.m705open = false;
            this.mApi.unmount(this.m705Dialog);
            this.sendUpdate();
        }
    }

    private void sendUpdate() {
        this.mServerContext.sendUpdate();
    }

    private void onButtonOkay(@NotNull CEventButtonPressedNotification aEvent) throws CException {
        this.mMainTarget.sendAddRight(this.mRight, this.mDescription);
        this.unmount();
    }

    private void onButtonCancel(@NotNull CEventButtonPressedNotification aEvent) {
        this.unmount();
    }
}

