/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.file.store.getfile;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.file.registry.CMicroServiceConstants;
import de.sillysky.nyssr.file.store.common.CUtilFileStore;
import de.sillysky.nyssr.file.store.records.CRecordFileStoreFile;
import de.sillysky.nyssr.file.store.records.CRecordFileStoreGetFileInfo;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.file.store.records.CRecordFileStoreGetChunk;
import de.sillysky.nyssr.impl.file.store.records.CRecordFileStoreNotifyFileDownloaded;
import de.sillysky.nyssr.impl.file.store.service.CFileDto;
import de.sillysky.nyssr.impl.file.store.service.IFileStore;
import de.sillysky.nyssr.job.CAbstractJob;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.result.CResult;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.thread.EThreadPriority;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.files.CUtilFile;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CDownloadFileJob
extends CAbstractJob {
    private static final ILogger LOG = CLoggerFactory.getLogger(CDownloadFileJob.class);
    private CTargetAddress mRemoteFileStoreAddress;
    private final String mRequestedPath;
    private final String mRequestedHash;
    private final IFileStore mFileStore;
    private CFileDto mFileDto = new CFileDto();
    private long mWritePosition = 0L;
    private File mFile;
    private byte[] mBytes;

    public CDownloadFileJob(@NotNull IFileStore aFileStore, @Nullable String aRequestedPath, @Nullable String aRequestedHash) {
        this.mFileStore = aFileStore;
        this.mRequestedPath = aRequestedPath;
        this.mRequestedHash = aRequestedHash;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordFileStoreGetFileInfo.ID, this::asyncAnswerGetFileInfo);
        this.addMessageHandler(CRecordFileStoreGetChunk.ID, this::asyncAnswerGetChunkFromStore);
    }

    public CDownloadFileJob(@NotNull IFileStore aFileStore, @NotNull String aPath, @NotNull String aHash, long aLength, @NotNull Instant aTimeOfCreation, @NotNull Instant aTimeOfLastModification, @NotNull CTargetAddress aRemoteFileStoreAddress) {
        this.mFileStore = aFileStore;
        this.mRequestedPath = aPath;
        this.mRequestedHash = aHash;
        this.mFileDto.setHash(aHash);
        this.mFileDto.setRelativePath(aPath);
        this.mFileDto.setLength(aLength);
        this.mFileDto.setTimeOfCreation(FileTime.from(aTimeOfCreation));
        this.mFileDto.setTimeOfLastModification(FileTime.from(aTimeOfLastModification));
        this.mRemoteFileStoreAddress = aRemoteFileStoreAddress;
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException, IOException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        if (this.mRemoteFileStoreAddress == null) {
            this.privateSendGetFile(this.mRequestedHash, this.mRequestedPath);
        } else {
            this.createNewFile();
            this.requestChunk();
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncAnswerGetFileInfo(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException, IOException {
        if (aEnvelope.isAnswer()) {
            CRecord record = CRecordFileStoreGetFileInfo.getFile((CRecord)aRecord, null);
            this.mFileDto = CFileDto.fromRecord(record);
            CResult result = aEnvelope.getResult();
            if (result.hasSuccess()) {
                this.mRemoteFileStoreAddress = aEnvelope.getSender();
                this.checkTrue(CUtilString.isValid((String)this.mFileDto.getHash()), "Hash");
                this.checkTrue(CUtilString.isValid((String)this.mFileDto.getRelativePath()), "Path");
                this.checkTrue(this.mFileDto.getLength() >= 0L, "file length");
                this.checkNotNull(this.mFileDto.getTimeOfCreation(), "Time of creation");
                this.checkNotNull(this.mFileDto.getTimeOfLastModification(), "Time of last modification");
                LOG.debug("Remote file store has file: {}", new Object[]{this.mFileDto});
                this.createNewFile();
                this.requestChunk();
            } else {
                LOG.debug("The remote file store does not recognize this file: {}", new Object[]{this.mFileDto});
                this.finish(result.getCode(), result.getText());
            }
            return true;
        }
        return false;
    }

    private boolean asyncAnswerGetChunkFromStore(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            CResult result = aEnvelope.getResult();
            if (result.hasSuccess()) {
                String hash = CRecordFileStoreGetChunk.getHash(aRecord, null);
                this.checkNotNull(hash, "Hash");
                this.checkTrue(hash.equals(this.mFileDto.getHash()), hash);
                byte[] bytes = CRecordFileStoreGetChunk.getBytes(aRecord, null);
                this.checkNotNull(bytes, "Bytes");
                long chunkPosition = CRecordFileStoreGetChunk.getChunkPosition(aRecord, -1L);
                this.checkTrue(chunkPosition == this.mWritePosition, "Position");
                if (this.mFileStore.getDirectoryForIncompleteFiles() == null) {
                    LOG.debug("Save chunk in memory: pos={}, length={}, file={}", new Object[]{chunkPosition, bytes.length, this.mFileDto.getRelativePath()});
                    this.addChunkToMemory(bytes);
                } else {
                    LOG.debug("Save chunk on disk: pos={}, length={}, file={}", new Object[]{chunkPosition, bytes.length, this.mFileDto.getRelativePath()});
                    CUtilFile.writeChunk((File)this.mFile, (long)chunkPosition, (byte[])bytes, (int)0, (int)bytes.length);
                }
                this.mWritePosition += (long)bytes.length;
                if (this.isFileComplete()) {
                    this.fileIsComplete();
                } else {
                    this.requestChunk();
                }
            }
            return true;
        }
        return false;
    }

    private void privateSendGetFile(@NotNull String aHash, @NotNull String aPath) throws CException {
        LOG.debug("Request file {} from Network File Registry", new Object[]{aPath});
        CRecord record1 = CRecordFileStoreGetFileInfo.create();
        CRecord record2 = CRecordFileStoreFile.create();
        CRecordFileStoreFile.setHash((CRecord)record2, (String)aHash);
        CRecordFileStoreFile.setPath((CRecord)record2, (String)aPath);
        CRecordFileStoreGetFileInfo.setFile((CRecord)record1, (CRecord)record2);
        CEnvelope env = CEnvelope.forMicroService((IId)CMicroServiceConstants.MICRO_SERVICE_ID);
        this.sendRequest(env, record1);
    }

    private void createNewFile() throws IOException {
        Path basePath;
        if (this.mFileStore.getDirectoryForIndexedFiles() != null && (basePath = this.mFileStore.getDirectoryForIncompleteFiles()) != null) {
            Path path = basePath.resolve(this.mFileDto.getHash() + ".part");
            this.mFile = path.toFile();
            LOG.debug("Create physical file: {}", new Object[]{this.mFile.getPath()});
            boolean success = this.mFile.createNewFile();
            if (!success) {
                LOG.debug("Couldn't create physical file (use memory): {}", new Object[]{this.mFile.getPath()});
            }
        }
    }

    private void requestChunk() throws CException {
        if (this.isFileComplete()) {
            this.fileIsComplete();
        } else {
            CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)this.mRemoteFileStoreAddress);
            CRecord record = CUtilFileStore.createRecordGetChunk(this.mFileDto.getHash(), this.mFileDto.getLength(), this.mWritePosition, this.mFileStore.getChunkSize());
            this.sendRequest(env, record);
        }
    }

    private void addChunkToMemory(byte[] aBytes) {
        if (aBytes != null && aBytes.length > 0) {
            if (this.mBytes == null) {
                this.mBytes = aBytes;
                this.mWritePosition = this.mBytes.length;
            } else {
                byte[] temp = new byte[this.mBytes.length + aBytes.length];
                System.arraycopy(this.mBytes, 0, temp, 0, this.mBytes.length);
                System.arraycopy(aBytes, 0, temp, this.mBytes.length, aBytes.length);
                this.mBytes = temp;
            }
        }
    }

    private boolean isFileComplete() {
        return this.mWritePosition == this.mFileDto.getLength();
    }

    private void fileIsComplete() throws CException {
        if (this.mFile != null && this.mFileStore.getDirectoryForIndexedFiles() != null) {
            this.mFile = CUtilFileStore.rename(this.mFileStore, this.mFile, this.mFileDto.getRelativePath(), this.mFileDto.getHash(), this.mFileDto.getTimeOfCreation(), this.mFileDto.getTimeOfLastModification());
            if (this.mFile == null) {
                LOG.error("Unable to rename file {}", new Object[]{this.mFileDto.getRelativePath()});
                this.finish(2, "Can't move file");
                return;
            }
        }
        this.finish(0, "");
    }

    private void checkNotNull(@Nullable Object aCheckMe, @Nullable String aName) throws CException {
        if (aCheckMe == null) {
            this.finish(8, "Argument is null: " + aName);
            throw new CException(8).append("Argument is null: ").append(aName);
        }
    }

    private void checkTrue(boolean aCheckMe, @Nullable String aName) throws CException {
        if (!aCheckMe) {
            this.finish(8, "Argument invalid: " + aName);
            throw new CException(8).append("Argument invalid: ").append(aName);
        }
    }

    private void finish(int aResultCode, @Nullable String aResultText) throws CException {
        CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)this.mFileStore.getAddress());
        FileTime toc = this.mFileDto.getTimeOfCreation();
        FileTime tom = this.mFileDto.getTimeOfLastModification();
        CRecord record = CRecordFileStoreNotifyFileDownloaded.create();
        CRecordFileStoreNotifyFileDownloaded.setPath(record, this.mRequestedPath);
        CRecordFileStoreNotifyFileDownloaded.setHash(record, this.mRequestedHash);
        CRecordFileStoreNotifyFileDownloaded.setResultCode(record, aResultCode);
        CRecordFileStoreNotifyFileDownloaded.setResultText(record, aResultText);
        if (aResultCode != 0) {
            LOG.error("Error downloading file: {}-{}", new Object[]{aResultCode, aResultText});
        } else {
            CRecord file = CUtilFileStore.fileToRecord(this.mFileDto.getHash(), this.mFileDto.getRelativePath(), this.mFileDto.getLength(), toc == null ? null : toc.toInstant(), tom == null ? null : tom.toInstant());
            CRecordFileStoreNotifyFileDownloaded.setFileEntry(record, file);
            CRecordFileStoreNotifyFileDownloaded.setBytes(record, this.mBytes);
            CRecordFileStoreNotifyFileDownloaded.setFile(record, this.mFile);
        }
        this.sendNotification(env, record);
        super.notifyJobStopped();
    }

    @NotNull
    public EThreadPriority getPriority() {
        return EThreadPriority.LOW;
    }

    @NotNull
    public String getJobName() {
        return "Download-" + this.mFileDto.getRelativePath() + '-' + this.mFileDto.getHash();
    }
}

