/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.app.widget.showcase.main;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.id.widget.CWidgetSetId;
import de.sillysky.nyssr.impl.app.widget.showcase.basics.CBasicsTarget;
import de.sillysky.nyssr.impl.app.widget.showcase.border.CBorderTarget;
import de.sillysky.nyssr.impl.app.widget.showcase.button.CButtonTarget;
import de.sillysky.nyssr.impl.app.widget.showcase.checkbox.CCheckBoxTarget;
import de.sillysky.nyssr.impl.app.widget.showcase.combobox.CComboBoxTarget;
import de.sillysky.nyssr.impl.app.widget.showcase.dialogs.CDialogsTarget;
import de.sillysky.nyssr.impl.app.widget.showcase.label.CLabelTarget;
import de.sillysky.nyssr.impl.app.widget.showcase.listbox.CListBoxTarget;
import de.sillysky.nyssr.impl.app.widget.showcase.main.CMainFrameModel;
import de.sillysky.nyssr.impl.app.widget.showcase.main.EWidgetSets;
import de.sillysky.nyssr.impl.app.widget.showcase.menu.CMenuTarget;
import de.sillysky.nyssr.impl.app.widget.showcase.progressbar.CProgressBarTarget;
import de.sillysky.nyssr.impl.app.widget.showcase.radiobutton.CRadioButtonTarget;
import de.sillysky.nyssr.impl.app.widget.showcase.slider.CSliderTarget;
import de.sillysky.nyssr.impl.app.widget.showcase.spinner.CSpinnerTarget;
import de.sillysky.nyssr.impl.app.widget.showcase.table.CTableTarget;
import de.sillysky.nyssr.impl.app.widget.showcase.textfield.CTextFieldTarget;
import de.sillysky.nyssr.impl.app.widget.showcase.toolbar.CToolbarTarget;
import de.sillysky.nyssr.impl.app.widget.showcase.tree.CTreeTarget;
import de.sillysky.nyssr.remoteskin.model.events.CEventListSelectionNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventWindowNotification;
import de.sillysky.nyssr.remoteskin.server.context.IRemoteSkinServerContext;
import de.sillysky.nyssr.remoteskin.server.context.IWidgetApi;
import de.sillysky.nyssr.remoteskin.server.listeners.IListSelectionListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IWindowClosingListener;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.util.CUtilEnum;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CMainFrameUi {
    private final CMainFrameModel mModel;
    private final IRemoteSkinServerContext mServerContext;
    private final IWidgetApi mApi;
    private final CWidgetSetId mWs300;
    private final CWidgetId mFrame;
    private final CWidgetId mList;
    private final CWidgetId mPanel;
    private final CWidgetId mMessagePanel;
    private CTarget mCurrentTarget;
    private EWidgetSets mCurrentWidgetSet;

    public CMainFrameUi(@NotNull CMainFrameModel aModel) {
        this.mModel = aModel;
        this.mServerContext = this.mModel.getAppContext().getRemoteSkinServerContext();
        this.mApi = this.mServerContext.getWidgetApi();
        this.mWs300 = CWidgetSetId.create((String)"@300_MainFrame", (String)"main");
        this.mFrame = CWidgetId.create((String)"#300_MainFrame", (CWidgetSetId)this.mWs300);
        this.mApi.addListener(this.mFrame, (IListener)((IWindowClosingListener)this::onWindowClosing));
        this.mList = CWidgetId.create((String)"#300_List", (CWidgetSetId)this.mWs300);
        this.mApi.addListener(this.mList, (IListener)((IListSelectionListener)this::onListSelection));
        this.mPanel = CWidgetId.create((String)"#300_Right_Panel", (CWidgetSetId)this.mWs300);
        this.mMessagePanel = CWidgetId.create((String)"#300_Panel_Message", (CWidgetSetId)this.mWs300);
    }

    private void onListSelection(@NotNull CEventListSelectionNotification aEvent) {
        String id;
        EWidgetSets widgetSet;
        List selectedIds = aEvent.getSelectedIds();
        if (!selectedIds.isEmpty() && (widgetSet = (EWidgetSets)((Object)CUtilEnum.fromString(EWidgetSets.class, (String)(id = (String)selectedIds.get(0)), (Object)((Object)EWidgetSets.basics)))) != this.mCurrentWidgetSet) {
            if (this.mCurrentTarget != null) {
                this.mCurrentTarget.deregisterTarget();
                this.mCurrentTarget = null;
            }
            switch (widgetSet) {
                case border: {
                    this.mCurrentTarget = new CBorderTarget(this.mModel.getAppContext(), this.mPanel);
                    break;
                }
                case button: {
                    this.mCurrentTarget = new CButtonTarget(this.mModel.getAppContext(), this.mPanel);
                    break;
                }
                case checkbox: {
                    this.mCurrentTarget = new CCheckBoxTarget(this.mModel.getAppContext(), this.mPanel);
                    break;
                }
                case combobox: {
                    this.mCurrentTarget = new CComboBoxTarget(this.mModel.getAppContext(), this.mPanel);
                    break;
                }
                case dialogs: {
                    this.mCurrentTarget = new CDialogsTarget(this.mModel.getAppContext(), this.mPanel);
                    break;
                }
                case label: {
                    this.mCurrentTarget = new CLabelTarget(this.mModel.getAppContext(), this.mPanel);
                    break;
                }
                case listbox: {
                    this.mCurrentTarget = new CListBoxTarget(this.mModel.getAppContext(), this.mPanel);
                    break;
                }
                case menu: {
                    this.mCurrentTarget = new CMenuTarget(this.mModel.getAppContext(), this.mPanel);
                    break;
                }
                case progressbar: {
                    this.mCurrentTarget = new CProgressBarTarget(this.mModel.getAppContext(), this.mPanel);
                    break;
                }
                case radiobutton: {
                    this.mCurrentTarget = new CRadioButtonTarget(this.mModel.getAppContext(), this.mPanel);
                    break;
                }
                case slider: {
                    this.mCurrentTarget = new CSliderTarget(this.mModel.getAppContext(), this.mPanel);
                    break;
                }
                case spinner: {
                    this.mCurrentTarget = new CSpinnerTarget(this.mModel.getAppContext(), this.mPanel);
                    break;
                }
                case table: {
                    this.mCurrentTarget = new CTableTarget(this.mModel.getAppContext(), this.mPanel);
                    break;
                }
                case textfield: {
                    this.mCurrentTarget = new CTextFieldTarget(this.mModel.getAppContext(), this.mPanel);
                    break;
                }
                case toolbar: {
                    this.mCurrentTarget = new CToolbarTarget(this.mModel.getAppContext(), this.mPanel);
                    break;
                }
                case tree: {
                    this.mCurrentTarget = new CTreeTarget(this.mModel.getAppContext(), this.mPanel);
                    break;
                }
                default: {
                    this.mCurrentTarget = new CBasicsTarget(this.mModel.getAppContext(), this.mPanel);
                }
            }
            try {
                this.mModel.getTarget().getTargetRegistry().registerTarget((ITarget)this.mCurrentTarget);
                this.mCurrentWidgetSet = widgetSet;
            }
            catch (CException aE) {
                aE.printStackTrace();
            }
        }
    }

    private void widgetSet300Mounted(@NotNull CWidgetSetId aWidgetSetId) throws CException {
        this.mModel.getTarget().onWidgetSetMounted();
        this.mModel.getTarget().showHistory();
        this.mApi.pack(this.mFrame);
        this.mApi.centerWidgetOnScreen(this.mFrame);
        this.mApi.selectItem(this.mList, EWidgetSets.basics.name());
        this.mApi.setVisible(this.mFrame, true);
        this.mServerContext.sendUpdate();
    }

    private void onWindowClosing(@NotNull CEventWindowNotification aValues) throws CException {
        this.mModel.getAppContext().closeContext();
        this.mModel.getTarget().deactivate();
    }

    void mountWidgetSet300() {
        this.mServerContext.mountWidgetSet(this.mWs300, null, "", this::widgetSet300Mounted);
        this.mServerContext.sendUpdate();
    }

    public CWidgetId getMessagePanel() {
        return this.mMessagePanel;
    }
}

