/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.app.widget.showcase.spinner;

import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.id.widget.CWidgetSetId;
import de.sillysky.nyssr.impl.app.widget.showcase.spinner.CSpinnerModel;
import de.sillysky.nyssr.remoteskin.model.events.CEventLocalDateTime;
import de.sillysky.nyssr.remoteskin.model.util.EMessageBoxType;
import de.sillysky.nyssr.remoteskin.server.context.IRemoteSkinServerContext;
import de.sillysky.nyssr.remoteskin.server.context.IWidgetApi;
import de.sillysky.nyssr.remoteskin.server.listeners.IDialogButtonListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IListener;
import de.sillysky.nyssr.remoteskin.server.listeners.ILocalDateTimeListener;
import de.sillysky.nyssr.remoteskin.server.widgets.CMessageBox;
import java.time.LocalDateTime;
import org.jetbrains.annotations.NotNull;

class CSpinnerUi {
    private final CSpinnerModel mModel;
    private final IRemoteSkinServerContext mServerContext;
    private final IWidgetApi mApi;
    private final CWidgetSetId mWs302;
    private final CWidgetId m302PanelMain;
    private final CWidgetId m302Spinner310;
    private final CWidgetId m302Spinner311;
    private boolean mMessageBoxShown = false;

    CSpinnerUi(@NotNull CSpinnerModel aModel) {
        this.mModel = aModel;
        this.mServerContext = aModel.getAppContext().getRemoteSkinServerContext();
        this.mApi = this.mServerContext.getWidgetApi();
        this.mWs302 = CWidgetSetId.create((String)"@302_Spinner", (String)this.mModel.getParent().getWidgetSetId().getInstance());
        this.m302PanelMain = CWidgetId.create((String)"#302_Panel_Main", (CWidgetSetId)this.mWs302);
        this.m302Spinner310 = CWidgetId.create((String)"#302_Component_010", (CWidgetSetId)this.mWs302);
        this.mApi.addListener(this.m302Spinner310, (IListener)((ILocalDateTimeListener)this::onChange310));
        this.m302Spinner311 = CWidgetId.create((String)"#302_Component_011", (CWidgetSetId)this.mWs302);
        this.mApi.addListener(this.m302Spinner311, (IListener)((ILocalDateTimeListener)this::onChange311));
    }

    private void onChange310(@NotNull CEventLocalDateTime aEvent) {
        this.showValue(this.m302Spinner310, aEvent.getLocalDateTime());
    }

    private void onChange311(@NotNull CEventLocalDateTime aEvent) {
        this.showValue(this.m302Spinner311, aEvent.getLocalDateTime());
    }

    private void widgetSet302Mounted(@NotNull CWidgetSetId aWidgetSetId) {
        this.mApi.setVisible(this.m302PanelMain, true);
        this.mServerContext.sendUpdate();
    }

    void mountWidgetSet302() {
        this.mServerContext.mountWidgetSet(this.mWs302, this.mModel.getParent(), "#302_Panel_Main", this::widgetSet302Mounted);
        this.mServerContext.sendUpdate();
    }

    private void showValue(CWidgetId aParent, LocalDateTime aValue) {
        if (!this.mMessageBoxShown) {
            this.mMessageBoxShown = true;
            CMessageBox msgBox = this.mServerContext.createMessageBox(this.mWs302, "#302MessageBox");
            msgBox.setTitle("Value Changed");
            msgBox.setText("Value is " + aValue);
            msgBox.setButtons(new String[]{"Okay", "Cancel"});
            msgBox.setMessageType(EMessageBoxType.information);
            this.mApi.setParent(msgBox.getWidgetId(), aParent);
            msgBox.setIndexOfEnterButton(0);
            msgBox.setIndexOfEscapeButton(1);
            msgBox.showDialog();
            msgBox.addListener((IListener)((IDialogButtonListener)this::onMessageBox));
            this.mServerContext.sendUpdate();
        }
    }

    private void onMessageBox(String ignore) {
        this.mMessageBoxShown = false;
    }

    public void dismiss() {
        this.mApi.unmount(this.m302PanelMain);
    }
}

