/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.client.node.ui;

import de.sillysky.nyssr.impl.client.node.ui.CUiStarterTarget;
import de.sillysky.nyssr.impl.client.node.ui.IClientNodeDependencies;
import de.sillysky.nyssr.kernel.configuration.IKernelConfiguration;
import de.sillysky.nyssr.microservice.collector.IMicroServiceRegistryCollector;
import de.sillysky.nyssr.namespace.INamespaceFactory;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.service.IServiceStarter;
import de.sillysky.nyssr.timer.ITimerManager;
import org.jetbrains.annotations.NotNull;

public class CPackageImplClientNodeUi
implements IServiceStarter,
IClientNodeDependencies {
    private IService mService;
    private ITimerManager mTimerManager;
    private IKernelConfiguration mKernelConfiguration;
    private INamespaceFactory mNamespaceFactory;
    private IMicroServiceRegistryCollector mMicroServiceRegistryCollector;

    public void getDependencies(@NotNull IServiceDependencyList aDependencyList) {
        aDependencyList.add(INamespaceFactory.class);
        aDependencyList.add(ITimerManager.class);
        aDependencyList.add(IKernelConfiguration.class);
        aDependencyList.add(IMicroServiceRegistryCollector.class);
    }

    public void start(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService == null) {
            this.mTimerManager = (ITimerManager)aServiceRegistry.getServiceOrThrow(ITimerManager.class);
            this.mKernelConfiguration = (IKernelConfiguration)aServiceRegistry.getServiceOrThrow(IKernelConfiguration.class);
            this.mMicroServiceRegistryCollector = (IMicroServiceRegistryCollector)aServiceRegistry.getServiceOrThrow(IMicroServiceRegistryCollector.class);
            this.mNamespaceFactory = (INamespaceFactory)aServiceRegistry.getServiceOrThrow(INamespaceFactory.class);
            this.mService = new CUiStarterTarget(this);
            this.mService.activate(aServiceRegistry);
        }
    }

    public void stop(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService != null) {
            this.mService.deactivate(aServiceRegistry);
            this.mService = null;
        }
    }

    @Override
    public IKernelConfiguration getKernelConfiguration() {
        return this.mKernelConfiguration;
    }

    @Override
    public ITimerManager getTimerManager() {
        return this.mTimerManager;
    }

    @Override
    public IMicroServiceRegistryCollector getMicroServiceRegistryCollector() {
        return this.mMicroServiceRegistryCollector;
    }

    @Override
    public INamespaceFactory getNamespaceFactory() {
        return this.mNamespaceFactory;
    }
}

