/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.exception;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import java.text.MessageFormat;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class CExceptionLogger {
    private CExceptionLogger() {
    }

    @Contract(value="_,_,_,_ -> fail")
    public static void logAndThrow(@NotNull Class<?> aOwner, int aResultCode, @NotNull String aFormat, Object ... aArguments) throws CException {
        String s = MessageFormat.format(aFormat, aArguments);
        ILogger logger = CLoggerFactory.getLogger(aOwner);
        logger.error(s, 1);
        throw new CException(aResultCode).append(s);
    }

    @Contract(value="_,_,_,_ -> fail")
    public static void logAndThrow(@NotNull String aOwner, int aResultCode, @NotNull String aFormat, Object ... aArguments) throws CException {
        String s = MessageFormat.format(aFormat, aArguments);
        ILogger logger = CLoggerFactory.getLogger(aOwner);
        logger.error(s, 1);
        throw new CException(aResultCode).append(s);
    }

    @Contract(value="_,_,_,_ -> fail")
    public static void logAndThrow(@NotNull Object aOwner, int aResultCode, @NotNull String aFormat, Object ... aArguments) throws CException {
        String s = MessageFormat.format(aFormat, aArguments);
        ILogger logger = CLoggerFactory.getLogger(aOwner.getClass());
        logger.error(s, 1);
        throw new CException(aResultCode).append(s);
    }
}

