/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.namespace.target;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.cli.ICommandLineInterface;
import de.sillysky.nyssr.cli.records.CRecordCliAddHandler;
import de.sillysky.nyssr.cli.records.CRecordCliHandle;
import de.sillysky.nyssr.cli.records.CRecordCliRemoveHandler;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.id.common.CWellKnownTID;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namedb.INameDb;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.namespace.INamespaceFactory;
import de.sillysky.nyssr.namespace.INamespaceRegistry;
import de.sillysky.nyssr.namespace.records.CRecordCreateNamespace;
import de.sillysky.nyssr.namespace.records.CRecordDeleteNamespace;
import de.sillysky.nyssr.namespace.records.CRecordGetNamespaceList;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.helper.CRecordHelper;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.registry.ITargetRegistry;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.timer.CTimer;
import de.sillysky.nyssr.timer.ITimerManager;
import org.jetbrains.annotations.NotNull;

final class CTargetForNamespaceRegistry
extends CTarget
implements IService {
    private static final String FILTER = "nid=SYSTEM";
    private static final ILogger LOG = CLoggerFactory.getLogger(CTargetForNamespaceRegistry.class);
    private static final IId TIMER_DUMP = CIdFactory.fromObject("TimerDump");
    private static final long TIMEOUT_DUMP = 10000L;
    private static final String LIST_NAMESPACES = "list namespaces";
    private static final String HELP_LIST_NAMESPACES = "List all namespaces and Number of targets, nanos, Queues, handled Messages";
    private INamespaceRegistry mNamespaceRegistry;
    private INamespaceFactory mNamespaceFactory;
    private INameDb mNameDb;
    private CTimer mTimerDump;
    private ITimerManager mTimerManager;

    CTargetForNamespaceRegistry() {
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordCreateNamespace.ID, this::asyncCreateNamespace);
        this.addMessageHandler(CRecordDeleteNamespace.ID, this::asyncDeleteNamespace);
        this.addMessageHandler(CRecordGetNamespaceList.ID, this::asyncGetNamespaceList);
        this.addMessageHandler(TIMER_DUMP, this::asyncTimerDump);
        this.addMessageHandler(CRecordCliHandle.ID, this::asyncHandleCli);
    }

    public static void getDependencies(IServiceDependencyList aList) {
        aList.add(INameDb.class);
        aList.add(INamespaceRegistry.class);
        aList.add(INamespaceFactory.class);
        aList.add(INamespace.class, FILTER);
        aList.add(ITimerManager.class);
        aList.add(ICommandLineInterface.class);
    }

    @Override
    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        LOG.debug("Activate {}", this.getClass().getSimpleName());
        this.mNamespaceRegistry = aServiceRegistry.getServiceOrThrow(INamespaceRegistry.class);
        this.mNamespaceFactory = aServiceRegistry.getServiceOrThrow(INamespaceFactory.class);
        this.mNameDb = aServiceRegistry.getServiceOrThrow(INameDb.class);
        this.mTimerManager = aServiceRegistry.getServiceOrThrow(ITimerManager.class);
        ITargetRegistry tr = aServiceRegistry.getServiceOrThrow(ITargetRegistry.class, FILTER);
        tr.registerTarget(this, CWellKnownTID.NAMESPACE_REGISTRY);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        CTargetAddress address = this.getAddress();
        this.mNameDb.getTargetAddressDatabase().putName(address, "NamespaceReg");
        CRecordHelper.addObserver(CRecordCreateNamespace.class, this, false);
        CRecordHelper.addObserver(CRecordDeleteNamespace.class, this, false);
        CRecordHelper.addObserver(CRecordGetNamespaceList.class, this, false);
        this.mTimerDump = new CTimer(this.mTimerManager, TIMER_DUMP, this.getAddress(), 10000L, true, null);
        this.mTimerDump.startIf();
        this.sendAddCli();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncCreateNamespace(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        String description;
        IId wantedNid = CRecordCreateNamespace.getWantedNid(aRecord, null);
        INamespace ns = this.mNamespaceFactory.createAndRegisterNamespace(wantedNid, description = CRecordCreateNamespace.getDescription(aRecord, ""));
        if (ns != null) {
            CRecordCreateNamespace.setCreatedNid(aRecord, ns.getNID());
            aEnvelope.setResultSuccess();
        } else {
            aEnvelope.setResult(15, "Couldn't create Namespace");
        }
        return true;
    }

    private boolean asyncDeleteNamespace(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        IId nid = CRecordDeleteNamespace.getNid(aRecord, null);
        CUtilCheck.checkNotNull(nid, "Missing Namespace ID", new Object[0]);
        this.mNamespaceFactory.deleteNamespace(nid);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncGetNamespaceList(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        IId[] ids = this.mNamespaceRegistry.getNamespaceIDs();
        CRecordGetNamespaceList.setNidList(aRecord, ids);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncTimerDump(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        this.mTimerDump.notifyTriggerOccurred();
        this.mNamespaceRegistry.dump();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncHandleCli(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        String command = CRecordCliHandle.getCommand(aRecord, null);
        if (LIST_NAMESPACES.equals(command)) {
            CRecordCliHandle.setOutput(aRecord, this.mNamespaceRegistry.getDump());
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    @Override
    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) throws CException {
        this.sendRemoveCli();
        this.deregisterTarget();
    }

    private void sendAddCli() throws CException {
        CEnvelope env = CEnvelope.forLocalNanoService(CWellKnownNID.SYSTEM);
        CRecord record = CRecordCliAddHandler.create();
        CRecordCliAddHandler.setCommand(record, new String[]{LIST_NAMESPACES});
        CRecordCliAddHandler.setHelp(record, new String[]{HELP_LIST_NAMESPACES});
        this.sendNotification(env, record);
    }

    private void sendRemoveCli() throws CException {
        CEnvelope env = CEnvelope.forLocalNanoService(CWellKnownNID.SYSTEM);
        CRecord record = CRecordCliRemoveHandler.create();
        this.sendNotification(env, record);
    }
}

