/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.log;

import de.sillysky.nyssr.impl.log.CLogMachine;
import de.sillysky.nyssr.log.ILogConfiguration;
import de.sillysky.nyssr.log.ILogMachine;
import de.sillysky.nyssr.log.ILogger;
import java.time.LocalDateTime;
import org.jetbrains.annotations.NotNull;

public class CLoggerFactory {
    private static final ILogMachine mMachine = CLogMachine.getInstance();
    private static LocalDateTime mStartTime;

    private CLoggerFactory() {
    }

    public static void setStartTime(@NotNull LocalDateTime aStartTime) {
        mStartTime = aStartTime;
    }

    @NotNull
    public static LocalDateTime getStartTime() {
        return mStartTime == null ? LocalDateTime.now() : mStartTime;
    }

    @NotNull
    public static ILogConfiguration getConfiguration() {
        return mMachine.getConfiguration();
    }

    @NotNull
    public static ILogger getLogger(@NotNull Class<?> aClass) {
        return mMachine.getLogger(aClass);
    }

    @NotNull
    public static ILogger getLogger(@NotNull String aName) {
        return mMachine.getLogger(aName);
    }
}

