/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util;

import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.util.CUtilString;
import org.jetbrains.annotations.Nullable;

public final class CUtilBoolean {
    private static final ILogger LOG = CLoggerFactory.getLogger(CUtilBoolean.class);

    private CUtilBoolean() {
    }

    public static boolean fromObject(@Nullable Object aValue, boolean aDefault) {
        boolean result = aDefault;
        if (aValue != null) {
            if (aValue instanceof Boolean) {
                result = (Boolean)aValue;
            } else if (aValue instanceof String) {
                result = CUtilBoolean.fromString((String)aValue);
            } else {
                LOG.error("Can't convert object {} to boolean. Take default value '{}'", aValue, aDefault);
            }
        }
        return result;
    }

    public static boolean fromString(@Nullable String aValue) {
        return CUtilBoolean.fromString(aValue, false);
    }

    public static Boolean fromString(@Nullable String aValue, boolean aDefault) {
        boolean result = aDefault;
        if (CUtilString.isValid(aValue) && !(result = Boolean.parseBoolean(aValue)) && !CUtilBoolean.isBoolean(aValue)) {
            result = aDefault;
        }
        return result;
    }

    public static String toString(boolean aValue) {
        return Boolean.toString(aValue);
    }

    public static String toString(boolean aValue, int aMaxLen) {
        StringBuffer sb = new StringBuffer(10);
        sb.append(aValue);
        String result = sb.length() > aMaxLen ? CUtilString.getShortenString(sb, aMaxLen) : sb.toString();
        return result;
    }

    public static boolean isBoolean(@Nullable Object aStr) {
        if (aStr instanceof Boolean) {
            return true;
        }
        if (aStr instanceof String) {
            String s = (String)aStr;
            boolean result = false;
            if (CUtilString.isValid(s)) {
                result = "false".equals(s = s.trim().toLowerCase()) || "true".equals(s);
            }
            return result;
        }
        return false;
    }
}

