/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.app.factory.collector;

import de.sillysky.nyssr.util.CUtilStringArray;
import de.sillysky.nyssr.util.properties.CStringProperties;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

class CApplicationEntry
implements Comparable<CApplicationEntry> {
    @NotNull
    private final UUID mApplicationId;
    @NotNull
    private final String mApplicationName;
    @NotNull
    private final String mShortApplicationDescription;
    @NotNull
    private final String mLongApplicationDescription;
    @NotNull
    private final String mPlatform;
    @NotNull
    private final CStringProperties mProperties;
    @NotNull
    private final String mIconPath;
    @NotNull
    private final String[] mPermissions;

    CApplicationEntry(@NotNull UUID aApplicationId, @NotNull String aApplicationName, @NotNull String aShortApplicationDescription, @NotNull String aLongApplicationDescription, @NotNull String aIconPath, @NotNull String aPlatform, @NotNull String[] aPermissions, @NotNull CStringProperties aProperties) {
        this.mApplicationId = aApplicationId;
        this.mApplicationName = aApplicationName;
        this.mShortApplicationDescription = aShortApplicationDescription;
        this.mLongApplicationDescription = aLongApplicationDescription;
        this.mIconPath = aIconPath;
        this.mPlatform = aPlatform;
        this.mPermissions = aPermissions;
        this.mProperties = aProperties;
    }

    @NotNull
    UUID getApplicationId() {
        return this.mApplicationId;
    }

    @NotNull
    String getApplicationName() {
        return this.mApplicationName;
    }

    @NotNull
    String getShortApplicationDescription() {
        return this.mShortApplicationDescription;
    }

    @NotNull
    String getLongApplicationDescription() {
        return this.mLongApplicationDescription;
    }

    @NotNull
    CStringProperties getProperties() {
        return this.mProperties;
    }

    @NotNull
    String getPlatform() {
        return this.mPlatform;
    }

    @NotNull
    String getIconPath() {
        return this.mIconPath;
    }

    @NotNull
    String[] getPermissions() {
        return this.mPermissions;
    }

    boolean isStartingAllowed(@NotNull String[] aUserRights) {
        for (String permissionNeeded : this.mPermissions) {
            if (CUtilStringArray.contains((String[])aUserRights, (String)permissionNeeded)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object aO) {
        if (this == aO) {
            return true;
        }
        if (aO == null || this.getClass() != aO.getClass()) {
            return false;
        }
        CApplicationEntry that = (CApplicationEntry)aO;
        return this.mApplicationId.equals(that.mApplicationId);
    }

    public int hashCode() {
        return this.mApplicationId.hashCode();
    }

    @Override
    public int compareTo(@NotNull CApplicationEntry aOther) {
        return this.mApplicationName.compareTo(aOther.mApplicationName);
    }
}

