/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.app.widget.showcase.toolbar;

import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.id.widget.CWidgetSetId;
import de.sillysky.nyssr.impl.app.widget.showcase.toolbar.CToolbarModel;
import de.sillysky.nyssr.remoteskin.model.enums.EPosition;
import de.sillysky.nyssr.remoteskin.model.enums.EWidgetOrientation;
import de.sillysky.nyssr.remoteskin.model.events.CEventButtonPressedNotification;
import de.sillysky.nyssr.remoteskin.server.context.IRemoteSkinServerContext;
import de.sillysky.nyssr.remoteskin.server.context.IWidgetApi;
import de.sillysky.nyssr.remoteskin.server.listeners.IButtonPressedListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IListener;
import org.jetbrains.annotations.NotNull;

public class CToolbarUi {
    private final CToolbarModel mModel;
    private final IRemoteSkinServerContext mServerContext;
    private final IWidgetApi mApi;
    private final CWidgetSetId mWs313;
    private final CWidgetId mToolbar_001;
    private final CWidgetId mToolbar_002;
    private final CWidgetId mLabel_002;
    private final CWidgetId mToolbar_003;
    private final CWidgetId mLabel_003;
    private final CWidgetId mToolbar_004;
    private CWidgetId m313PanelMain;
    private EPosition mLastBorder = EPosition.west;

    public CToolbarUi(@NotNull CToolbarModel aModel) {
        this.mModel = aModel;
        this.mServerContext = aModel.getAppContext().getRemoteSkinServerContext();
        this.mApi = this.mServerContext.getWidgetApi();
        String instance = this.mModel.getParent().getWidgetSetId().getInstance();
        this.mWs313 = CWidgetSetId.create((String)"@313_Toolbar", (String)instance);
        this.mToolbar_001 = CWidgetId.create((String)"#313_01_Toolbar", (String)"@313_01_Toolbar", (String)instance);
        CWidgetId button001 = CWidgetId.create((String)"#313_Helper_001", (CWidgetSetId)this.mWs313);
        this.mApi.addListener(button001, (IListener)((IButtonPressedListener)this::onButton01));
        this.mLabel_002 = CWidgetId.create((String)"#313_Helper_002", (CWidgetSetId)this.mWs313);
        this.mToolbar_002 = CWidgetId.create((String)"#313_02_Toolbar", (String)"@313_02_Toolbar", (String)instance);
        CWidgetId button1_002 = CWidgetId.create((String)"#313_02_Button1", (String)"@313_02_Toolbar", (String)instance);
        this.mApi.addListener(button1_002, (IListener)((IButtonPressedListener)this::onButton002_01));
        this.mLabel_003 = CWidgetId.create((String)"#313_Helper_003", (CWidgetSetId)this.mWs313);
        this.mToolbar_003 = CWidgetId.create((String)"#313_03_Toolbar", (String)"@313_03_Toolbar", (String)instance);
        CWidgetId button1_003 = CWidgetId.create((String)"#313_03_Button1", (String)"@313_03_Toolbar", (String)instance);
        this.mApi.addListener(button1_003, (IListener)((IButtonPressedListener)this::onButton003_01));
        this.mToolbar_004 = CWidgetId.create((String)"#313_04_Toolbar", (String)"@313_04_Toolbar", (String)instance);
    }

    private void onButton01(@NotNull CEventButtonPressedNotification aEvent) {
        EWidgetOrientation orientation;
        EPosition nextBorder;
        switch (this.mLastBorder) {
            case east: {
                nextBorder = EPosition.south;
                orientation = EWidgetOrientation.horizontal;
                break;
            }
            case south: {
                nextBorder = EPosition.west;
                orientation = EWidgetOrientation.vertical;
                break;
            }
            case west: {
                nextBorder = EPosition.north;
                orientation = EWidgetOrientation.horizontal;
                break;
            }
            default: {
                nextBorder = EPosition.east;
                orientation = EWidgetOrientation.vertical;
            }
        }
        this.mLastBorder = nextBorder;
        this.mApi.setOrientation(this.mToolbar_001, orientation);
        this.mApi.moveToolbar(this.mToolbar_001, nextBorder);
        this.mServerContext.sendUpdate();
    }

    private void onButton002_01(@NotNull CEventButtonPressedNotification aEvent) {
        if (aEvent.isSelected()) {
            this.mApi.setBorderPainted(this.mToolbar_002, true);
            this.mApi.setText(this.mLabel_002, "Border painted");
        } else {
            this.mApi.setBorderPainted(this.mToolbar_002, false);
            this.mApi.setText(this.mLabel_002, "Border not painted");
        }
        this.mServerContext.sendUpdate();
    }

    private void onButton003_01(@NotNull CEventButtonPressedNotification aEvent) {
        if (aEvent.isSelected()) {
            this.mApi.setFloatable(this.mToolbar_003, true);
            this.mApi.setText(this.mLabel_003, "floatable");
        } else {
            this.mApi.setFloatable(this.mToolbar_003, false);
            this.mApi.setText(this.mLabel_003, "not floatable");
        }
        this.mServerContext.sendUpdate();
    }

    private void widgetSet313Mounted(@NotNull CWidgetSetId aWidgetSetId) {
        this.m313PanelMain = CWidgetId.create((String)"#313_Panel", (CWidgetSetId)this.mWs313);
        this.mApi.setVisible(this.m313PanelMain, true);
        this.mServerContext.sendUpdate();
        this.mModel.getAppContext().sendOtherWidgetSets();
    }

    void mountWidgetSet313() {
        this.mServerContext.mountWidgetSet(this.mWs313, this.mModel.getParent(), "#313_Panel", this::widgetSet313Mounted);
        this.mServerContext.sendUpdate();
    }

    public void dismiss() {
        this.mApi.unmount(this.m313PanelMain);
    }
}

