/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.icon.store;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.impl.remoteskin.client.icon.store.CIconEntry;
import de.sillysky.nyssr.impl.remoteskin.client.icon.store.CIconList;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.namespace.INamespaceFactory;
import de.sillysky.nyssr.namespace.IRecordHelper;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.client.IIconStore;
import de.sillysky.nyssr.remoteskin.client.icon.store.records.CRecordRemoteSkinPushIcon;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CIconStore
extends CTarget
implements IService,
IIconStore {
    private final CIconList mIcons = new CIconList();
    private IRecordHelper mRecordHelper;

    static void getDependencies(IServiceDependencyList aDependencyList) {
        aDependencyList.add(INamespaceFactory.class);
        aDependencyList.add(IRecordHelper.class);
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordRemoteSkinPushIcon.ID, this::asyncPushIcon);
        this.mRecordHelper = (IRecordHelper)aServiceRegistry.getService(IRecordHelper.class);
        INamespaceFactory nsFactory = (INamespaceFactory)aServiceRegistry.getServiceOrThrow(INamespaceFactory.class);
        INamespace ns = nsFactory.createAndRegisterNamespace(CWellKnownNID.REMOTE_SKIN, "RemoteSkin");
        ns.getTargetRegistry().registerTarget((ITarget)this);
        aServiceRegistry.registerService(IIconStore.class, (Object)this);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.mRecordHelper.addObserver(CRecordRemoteSkinPushIcon.class, (ITarget)this, true);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncPushIcon(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        String name = CRecordRemoteSkinPushIcon.getName(aRecord, "");
        CUtilCheck.checkEmptyString((Object)name, (String)"Name missing", (Object[])new Object[0]);
        String description = CRecordRemoteSkinPushIcon.getDescription(aRecord, "");
        byte[] bytes = CRecordRemoteSkinPushIcon.getIcon(aRecord, null);
        CUtilCheck.checkNotNull((Object)bytes, (String)"Icon missing", (Object[])new Object[0]);
        CNodeAddress origin = aEnvelope.getSender().getNodeAddress();
        CIconEntry e = new CIconEntry(name, description, bytes, origin);
        this.mIcons.addIcon(e);
        aEnvelope.setResultSuccess();
        return true;
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.deregisterService((Object)this);
        this.deregisterTarget();
    }

    @Override
    public ImageIcon getIcon(@Nullable String aName) {
        CIconEntry e = this.mIcons.get(aName);
        if (e != null) {
            return e.getIcon();
        }
        return null;
    }

    @Override
    public ImageIcon getIcon(@Nullable String aName, @Nullable CNodeAddress aNodeForFetch) {
        CIconEntry e = this.mIcons.get(aName);
        if (e != null) {
            CNodeAddress origin;
            ImageIcon icon = e.getIcon();
            if (icon != null) {
                return icon;
            }
            if (aNodeForFetch != null && !aNodeForFetch.equals((Object)(origin = e.getOrigin()))) {
                this.fetchIcon(e, aNodeForFetch);
            }
        }
        return null;
    }

    @Override
    public boolean hasIcon(@Nullable String aName) {
        return this.mIcons.hasIcon(aName);
    }

    private void fetchIcon(@NotNull CIconEntry aEntry, @NotNull CNodeAddress aNodeForFetch) {
        String name = aEntry.getName();
    }
}

