/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events;

import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonString;
import de.sillysky.nyssr.remoteskin.model.events.CEventColor;
import de.sillysky.nyssr.remoteskin.model.events.CEventWidgetId;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventTabProperties
implements IRemoteSkinEvent {
    private static final String COMPONENT = "component";
    private static final String TITLE = "title";
    private static final String COLOR = "color";
    private CWidgetId mComponent = null;
    private String mTitle = null;
    private CEventColor mColor = null;

    @Nullable
    public static CEventTabProperties create(@Nullable Object aValue) {
        if (aValue instanceof CJsonObject) {
            CJsonObject jo = (CJsonObject)aValue;
            CEventTabProperties event = new CEventTabProperties();
            CEventWidgetId ev1 = CEventWidgetId.create(jo.getValue(COMPONENT));
            if (ev1 != null) {
                event.setComponent(ev1.getWidgetId());
            }
            String title = CUtilJsonString.fromJson((CJsonObject)jo, (String)TITLE, (String)"-?-");
            event.setTitle(title);
            CEventColor ev2 = CEventColor.create(jo.getValue(COLOR));
            event.setColor(ev2);
            return event;
        }
        return null;
    }

    @Nullable
    public CWidgetId getComponent() {
        return this.mComponent;
    }

    public void setComponent(@Nullable CWidgetId aComponent) {
        this.mComponent = aComponent;
    }

    @Nullable
    public String getTitle() {
        return this.mTitle;
    }

    public void setTitle(@Nullable String aTitle) {
        this.mTitle = aTitle;
    }

    @Nullable
    public CEventColor getColor() {
        return this.mColor;
    }

    public void setColor(@Nullable CEventColor aColor) {
        this.mColor = aColor;
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject();
        CEventWidgetId ev1 = new CEventWidgetId(this.mComponent);
        jo.put(COMPONENT, ev1.toJson());
        jo.put(TITLE, (Object)this.mTitle);
        if (this.mColor != null) {
            jo.put(COLOR, this.mColor.toJson());
        }
        return jo;
    }
}

