/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events.border;

import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonString;
import de.sillysky.nyssr.remoteskin.model.events.border.CEventBevelBorder;
import de.sillysky.nyssr.remoteskin.model.events.border.CEventBubbleBorder;
import de.sillysky.nyssr.remoteskin.model.events.border.CEventCompoundBorder;
import de.sillysky.nyssr.remoteskin.model.events.border.CEventDashedBorder;
import de.sillysky.nyssr.remoteskin.model.events.border.CEventEmptyBorder;
import de.sillysky.nyssr.remoteskin.model.events.border.CEventEtchedBorder;
import de.sillysky.nyssr.remoteskin.model.events.border.CEventLineBorder;
import de.sillysky.nyssr.remoteskin.model.events.border.CEventMatteBorder;
import de.sillysky.nyssr.remoteskin.model.events.border.CEventStrokeBorder;
import de.sillysky.nyssr.remoteskin.model.events.border.CEventTitledBorder;
import de.sillysky.nyssr.remoteskin.model.events.border.EBorderPropertyKeys;
import de.sillysky.nyssr.remoteskin.model.events.border.EBorderType;
import de.sillysky.nyssr.remoteskin.model.events.border.IBorder;
import de.sillysky.nyssr.util.CUtilEnum;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CJsonBorderUtil {
    private CJsonBorderUtil() {
    }

    @Nullable
    public static IBorder create(@Nullable Object aValue) {
        CJsonObject jo;
        String s;
        EBorderType borderType;
        if (aValue instanceof CJsonObject && (borderType = (EBorderType)((Object)CUtilEnum.fromString(EBorderType.class, (String)(s = CUtilJsonString.fromJson((CJsonObject)(jo = (CJsonObject)aValue), (String)EBorderPropertyKeys.border_type.name(), null)), null))) != null) {
            switch (borderType) {
                case empty: {
                    return CEventEmptyBorder.create(jo);
                }
                case line: {
                    return CEventLineBorder.create(jo);
                }
                case bevel: {
                    return CEventBevelBorder.create(jo);
                }
                case dashed: {
                    return CEventDashedBorder.create(jo);
                }
                case etched: {
                    return CEventEtchedBorder.create(jo);
                }
                case stroke: {
                    return CEventStrokeBorder.create(jo);
                }
                case titled: {
                    return CEventTitledBorder.create(jo);
                }
                case matte: {
                    return CEventMatteBorder.create(jo);
                }
                case compound: {
                    return CEventCompoundBorder.create(jo);
                }
                case bubble: {
                    return CEventBubbleBorder.create(jo);
                }
            }
        }
        return null;
    }

    @Nullable
    public static IBorder createBorder(@NotNull CJsonObject aJsonObject) {
        Object o = aJsonObject.getValue("emptyBorder");
        if (o != null) {
            return CEventEmptyBorder.create(o);
        }
        o = aJsonObject.getValue("lineBorder");
        if (o != null) {
            return CEventLineBorder.create(o);
        }
        o = aJsonObject.getValue("bevelBorder");
        if (o != null) {
            return CEventBevelBorder.create(o);
        }
        o = aJsonObject.getValue("dashedBorder");
        if (o != null) {
            return CEventDashedBorder.create(o);
        }
        o = aJsonObject.getValue("etchedBorder");
        if (o != null) {
            return CEventEtchedBorder.create(o);
        }
        o = aJsonObject.getValue("strokeBorder");
        if (o != null) {
            return CEventStrokeBorder.create(o);
        }
        o = aJsonObject.getValue("titledBorder");
        if (o != null) {
            return CEventTitledBorder.create(o);
        }
        o = aJsonObject.getValue("matteBorder");
        if (o != null) {
            return CEventMatteBorder.create(o);
        }
        o = aJsonObject.getValue("compoundBorder");
        if (o != null) {
            return CEventCompoundBorder.create(o);
        }
        o = aJsonObject.getValue("bubbleBorder");
        if (o != null) {
            return CEventBubbleBorder.create(o);
        }
        o = aJsonObject.getValue("border");
        if (o != null) {
            return CJsonBorderUtil.create(o);
        }
        return null;
    }
}

