/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.dev.check;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.impl.dev.check.IDependencies;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namedb.IRecordIdDatabase;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.namespace.INamespaceRegistry;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.timer.CTimer;
import de.sillysky.nyssr.util.CUtilString;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class CDevCheckTarget
extends CTarget
implements IService {
    private static final IId TIMER_ID = CIdFactory.fromObject((Object)"TIMER");
    private static final ILogger LOG = CLoggerFactory.getLogger(CDevCheckTarget.class);
    private final IDependencies mDependencies;
    private CTimer mTimer;

    CDevCheckTarget(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(TIMER_ID, this::asyncTimer);
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        INamespaceRegistry namespaceRegistry = this.mDependencies.getNamespaceRegistry();
        INamespace namespace = namespaceRegistry.getNamespace(CWellKnownNID.SYSTEM);
        assert (namespace != null);
        namespace.getTargetRegistry().registerTarget((ITarget)this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        this.deregisterTarget();
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CTargetAddress address = this.getAddress();
        this.mTimer = new CTimer(this.mDependencies.getTimerManager(), TIMER_ID, address, 5000L, false, null);
        this.mTimer.startIf();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncTimer(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.mTimer.notifyTriggerOccurred();
        if (LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(CUtilString.LINE_CRLF);
            sb.append("Record id statistic\n");
            sb.append(CUtilString.LINE_CRLF);
            Map recordIdStatistic = this.getMessageSender().getRecordIdStatistic();
            IRecordIdDatabase recordIdDatabase = this.mDependencies.getNameDb().getRecordIdDatabase();
            String[][] names = new String[recordIdStatistic.size()][3];
            int[] spaltenBreiten = new int[3];
            int i = 0;
            for (Map.Entry entry : recordIdStatistic.entrySet()) {
                IId key = (IId)entry.getKey();
                names[i][0] = key.toString();
                spaltenBreiten[0] = Math.max(spaltenBreiten[0], names[i][0].length());
                String name = recordIdDatabase.getNameOrNull(key);
                names[i][1] = name == null ? "" : name;
                spaltenBreiten[1] = Math.max(spaltenBreiten[1], names[i][1].length());
                names[i][2] = ((Integer)entry.getValue()).toString();
                spaltenBreiten[2] = Math.max(spaltenBreiten[2], names[i][2].length());
                ++i;
            }
            for (int row = 0; row < recordIdStatistic.size(); ++row) {
                String s = String.format("%-" + (spaltenBreiten[0] + 2) + "s", names[row][0]);
                sb.append(s);
                s = String.format("%-" + (spaltenBreiten[1] + 2) + "s", names[row][1]);
                sb.append(s);
                s = String.format("%" + (spaltenBreiten[2] + 2) + "d", Integer.parseInt(names[row][2]));
                sb.append(s);
                sb.append("\n");
            }
            LOG.debug(sb.toString());
        }
        this.mTimer.startIf();
        aEnvelope.setResultSuccess();
        return true;
    }
}

