/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.nodechooserdlg.target;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namedb.INameDb;
import de.sillysky.nyssr.network.nodechooserdlg.IDialogNodeChooser;
import de.sillysky.nyssr.network.nodechooserdlg.records.CRecordNetworkChooseNode;
import de.sillysky.nyssr.network.nodechooserdlg.records.CRecordNetworkNotifyNodeChosen;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.helper.CRecordHelper;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.ITargetRegistry;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import org.jetbrains.annotations.NotNull;

final class CTargetForDialogNodeChooser
extends CTarget
implements IService {
    private static final String FILTER = "nid=TRANSPORT";
    private static final ILogger LOG = CLoggerFactory.getLogger(CTargetForDialogNodeChooser.class);
    private INameDb mNameDb;
    private IDialogNodeChooser mChooser;

    CTargetForDialogNodeChooser() {
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordNetworkChooseNode.ID, this::asyncChooseNode);
    }

    public static void getDependencies(IServiceDependencyList aDependencyList) {
        aDependencyList.add(INameDb.class);
        aDependencyList.add(IDialogNodeChooser.class);
        aDependencyList.add(ITargetRegistry.class, FILTER);
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        LOG.debug("Activate {}", new Object[]{((Object)((Object)this)).getClass().getSimpleName()});
        this.mNameDb = (INameDb)aServiceRegistry.getService(INameDb.class);
        this.mChooser = (IDialogNodeChooser)aServiceRegistry.getService(IDialogNodeChooser.class);
        ITargetRegistry tr = (ITargetRegistry)aServiceRegistry.getService(ITargetRegistry.class, FILTER);
        assert (tr != null);
        tr.registerTarget((ITarget)this);
    }

    private boolean asyncChooseNode(CEnvelope aEnvelope, CRecord aRecord) {
        boolean modal = CRecordNetworkChooseNode.getModal((CRecord)aRecord, (boolean)true);
        Object parent = CRecordNetworkChooseNode.getParentWindow((CRecord)aRecord, null);
        String title = CRecordNetworkChooseNode.getTitle((CRecord)aRecord, (String)"Choose Node");
        CTargetAddress owner = aEnvelope.getSender();
        if (parent == null || parent instanceof Frame) {
            this.mChooser.showDialog((Frame)parent, title, modal, owner);
            aEnvelope.setResultSuccess();
        } else if (parent instanceof Dialog) {
            this.mChooser.showDialog((Dialog)parent, title, modal, owner);
            aEnvelope.setResultSuccess();
        } else if (parent instanceof Window) {
            this.mChooser.showDialog((Window)parent, title, modal, owner);
            aEnvelope.setResultSuccess();
        } else {
            aEnvelope.setResult(7, "Invalid parent.");
        }
        return true;
    }

    private boolean asyncStartTarget(CEnvelope aEnvelope, CRecord aRecord) throws CException {
        this.mNameDb.getTargetAddressDatabase().putName(this.getAddress(), "NodeChooser");
        this.mNameDb.getRecordIdDatabase().putName(CRecordNetworkNotifyNodeChosen.ID, "NotifyNodeIdChosen");
        CRecordHelper.addObserver(CRecordNetworkChooseNode.class, (ITarget)this, (boolean)false);
        aEnvelope.setResultSuccess();
        return true;
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        this.deregisterTarget();
    }
}

