/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.microservice.registry.service;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.microservice.registry.service.CListenerEntry;
import de.sillysky.nyssr.impl.microservice.registry.service.CListenerList;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class CListenerRegistry {
    private final Map<IId, CListenerList> mListener = new HashMap<IId, CListenerList>();

    CListenerRegistry() {
    }

    public void add(@NotNull CListenerEntry aEntry) {
        IId microServiceId = aEntry.getMicroServiceId();
        CListenerList list = this.mListener.get(microServiceId);
        if (list == null) {
            list = new CListenerList(microServiceId);
            this.mListener.put(microServiceId, list);
        }
        list.add(aEntry);
    }

    void remove(@NotNull CListenerEntry aEntry) {
        IId microServiceId = aEntry.getMicroServiceId();
        CListenerList list = this.mListener.get(microServiceId);
        if (list != null) {
            list.remove(aEntry);
        }
    }

    void remove(@NotNull CTargetAddress aAddress) {
        for (CListenerList list : this.mListener.values()) {
            list.remove(aAddress);
        }
    }

    public void remove(@NotNull IId aMicroServiceId, @NotNull CTargetAddress aAddress) {
        CListenerList list = this.mListener.get(aMicroServiceId);
        if (list != null) {
            list.remove(aAddress);
        }
    }

    int size() {
        int size = 0;
        for (CListenerList list : this.mListener.values()) {
            size += list.size();
        }
        return size;
    }

    CListenerList get(@NotNull IId aMicroServiceId) {
        return this.mListener.get(aMicroServiceId);
    }

    public String toString() {
        return this.size() + " Entries";
    }
}

