/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.packet.consumer.message;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.address.CSegmentId;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownTID;
import de.sillysky.nyssr.impl.network.packet.consumer.message.IDependencies;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.CMessage;
import de.sillysky.nyssr.message.CRoutingHint;
import de.sillysky.nyssr.message.IMessageSender;
import de.sillysky.nyssr.network.nodeinfo.CNodeInfoDto;
import de.sillysky.nyssr.network.packets.EPacketType;
import de.sillysky.nyssr.network.packets.IPacket;
import de.sillysky.nyssr.network.packets.IPacketContext;
import de.sillysky.nyssr.network.packets.IPacketMessage;
import de.sillysky.nyssr.network.packets.IPacketTypeConsumer;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;

final class CPacketConsumerMessage
implements IPacketTypeConsumer,
IService {
    private static final ILogger LOG_MSG = CLoggerFactory.getLogger((String)"MessageTransport");
    private static final ILogger LOG = CLoggerFactory.getLogger(CPacketConsumerMessage.class);
    @NotNull
    private final IDependencies mDependencies;

    CPacketConsumerMessage(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) {
        this.mDependencies.getPacketConsumerRegistry().registerPacketConsumer(this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        this.mDependencies.getPacketConsumerRegistry().deregisterPacketConsumer(this);
    }

    @Override
    public void consumePacket(@NotNull IPacketContext aContext, @NotNull IPacket aPacket) throws CException {
        CNodeAddress localNode = aContext.getLocalNode();
        IPacketMessage packet = (IPacketMessage)aPacket;
        CNodeAddress source = packet.getSource();
        CNodeAddress destination = packet.getDestination();
        if (!CNodeAddress.isValid((CNodeAddress)destination) || localNode.equals((Object)destination) || !source.getSegmentId().isLocal()) {
            try {
                packet.unpack();
                this.finishedReading(aContext, packet);
            }
            catch (CException e) {
                if (e.getCode() == 26) {
                    CNodeAddress remoteNode = packet.getSource();
                    aContext.getDependencies().getRouter().renewNodeRecord(remoteNode);
                }
                throw e;
            }
            catch (Exception e) {
                throw new CException((Throwable)e);
            }
        } else {
            aContext.forwardPacketToOtherTransport(packet);
        }
    }

    private boolean finishedReading(@NotNull IPacketContext aContext, @NotNull IPacketMessage aPacket) {
        CMessage msg = aPacket.getMessage();
        if (msg != null) {
            CEnvelope env = msg.getEnvelope();
            CTargetAddress receiver = env.getReceiver();
            CTargetAddress sender = env.getSender();
            CNodeAddress remoteNode = aContext.getRemoteNode();
            try {
                CNodeInfoDto senderInfo;
                CRoutingHint routingHint;
                CSegmentId remoteSegmentId;
                CSegmentId localSegmentId;
                CSegmentId segmentId;
                Stack receivers;
                IId tid = receiver.getTID();
                if (CWellKnownTID.TRANSPORT.equals((Object)tid)) {
                    receiver = aContext.getTarget().getAddress();
                    env.setReceiver(receiver);
                }
                if (!receiver.getNID().isValid() && (receivers = env.getReceivers()).size() > 1) {
                    receivers.pop();
                    receiver = env.getReceiver();
                }
                boolean isNewSender = false;
                CNodeId nodeId = sender.getNodeId();
                if (!nodeId.isValid()) {
                    nodeId = remoteNode.getNodeId();
                    isNewSender = true;
                }
                if (!(segmentId = sender.getSegmentId()).isValid() && !(localSegmentId = aContext.getLocalNode().getSegmentId()).equals((Object)(remoteSegmentId = remoteNode.getSegmentId()))) {
                    segmentId = remoteSegmentId;
                    nodeId = new CNodeId(nodeId.getId());
                    isNewSender = true;
                }
                if (isNewSender) {
                    CTargetAddress newSender = new CTargetAddress(sender.getTID(), sender.getNID(), nodeId, segmentId);
                    env.setSender(newSender);
                }
                if ((routingHint = env.getRoutingHint()) != null) {
                    this.mDependencies.getRoutingHintRegistry().add(routingHint);
                }
                if ((senderInfo = this.mDependencies.getNodeInfoDatabase().getNodeInfo(remoteNode)) != null && senderInfo.isClient()) {
                    env.setRoutingHint(new CRoutingHint(remoteNode, CNodeId.getLocal()));
                }
                LOG_MSG.trace("Transport: Got Msg {}, size={} bytes", new Object[]{env.getInstanceId(), aPacket.size()});
                if (!remoteNode.getSegmentId().isLocal()) {
                    aContext.sendToBridgeHead(remoteNode, msg);
                } else {
                    aContext.sendToLocal(msg);
                }
            }
            catch (Exception e) {
                LOG.error("Error handling incoming Message: {}", new Object[]{msg});
                try {
                    IMessageSender senderService = aContext.getCentralSender();
                    msg.getEnvelope().setBlocked(false);
                    senderService.sendBack(msg);
                }
                catch (CException e1) {
                    LOG.error("Error send back incoming Message: {}", new Object[]{msg});
                }
            }
        }
        return false;
    }

    @Override
    @NotNull
    public EPacketType getType() {
        return EPacketType.MESSAGE;
    }
}

